/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import java.util.Set;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.StatementContext;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.impl.api.CompositeStatementContext;
import org.neo4j.kernel.impl.api.PersistenceCache;
import org.neo4j.kernel.impl.api.SchemaCache;
import org.neo4j.kernel.impl.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.nioneo.store.IndexRule;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;

public class CachingStatementContext
extends CompositeStatementContext {
    private static final Function<? super SchemaRule, IndexDescriptor> TO_INDEX_RULE = new Function<SchemaRule, IndexDescriptor>(){

        @Override
        public IndexDescriptor apply(SchemaRule from) {
            IndexRule rule = (IndexRule)from;
            return new IndexDescriptor(rule.getLabel(), rule.getPropertyKey());
        }
    };
    private final PersistenceCache persistenceCache;
    private final SchemaCache schemaCache;
    private final StatementContext delegate;

    public CachingStatementContext(StatementContext actual, PersistenceCache persistenceCache, SchemaCache schemaCache) {
        super(actual);
        this.persistenceCache = persistenceCache;
        this.schemaCache = schemaCache;
        this.delegate = actual;
    }

    @Override
    public boolean nodeHasLabel(long nodeId, long labelId) throws EntityNotFoundException {
        Set<Long> labels = this.persistenceCache.getLabels(nodeId);
        if (labels != null) {
            return labels.contains(labelId);
        }
        return this.delegate.nodeHasLabel(nodeId, labelId);
    }

    @Override
    public Iterator<Long> nodeGetLabels(long nodeId) throws EntityNotFoundException {
        Set<Long> labels = this.persistenceCache.getLabels(nodeId);
        if (labels != null) {
            return labels.iterator();
        }
        return this.delegate.nodeGetLabels(nodeId);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(long labelId) {
        return CachingStatementContext.toIndexDescriptors(this.schemaCache.getSchemaRulesForLabel(labelId), SchemaRule.Kind.INDEX_RULE);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll() {
        return CachingStatementContext.toIndexDescriptors(this.schemaCache.getSchemaRules(), SchemaRule.Kind.INDEX_RULE);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(long labelId) {
        return CachingStatementContext.toIndexDescriptors(this.schemaCache.getSchemaRulesForLabel(labelId), SchemaRule.Kind.CONSTRAINT_INDEX_RULE);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetAll() {
        return CachingStatementContext.toIndexDescriptors(this.schemaCache.getSchemaRules(), SchemaRule.Kind.CONSTRAINT_INDEX_RULE);
    }

    private static Iterator<IndexDescriptor> toIndexDescriptors(Iterable<SchemaRule> rules, final SchemaRule.Kind kind) {
        Iterator<SchemaRule> filteredRules = Iterables.filter(new Predicate<SchemaRule>(){

            @Override
            public boolean accept(SchemaRule item) {
                return item.getKind() == kind;
            }
        }, rules.iterator());
        return Iterables.map(TO_INDEX_RULE, filteredRules);
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(IndexDescriptor index) throws SchemaRuleNotFoundException {
        IndexRule rule = this.indexRule(index);
        if (rule != null) {
            return rule.getOwningConstraint();
        }
        return this.delegate.indexGetOwningUniquenessConstraintId(index);
    }

    @Override
    public long indexGetCommittedId(IndexDescriptor index) throws SchemaRuleNotFoundException {
        IndexRule rule = this.indexRule(index);
        if (rule != null) {
            return rule.getId();
        }
        return this.delegate.indexGetCommittedId(index);
    }

    private IndexRule indexRule(IndexDescriptor index) {
        for (SchemaRule rule : this.schemaCache.getSchemaRulesForLabel(index.getLabelId())) {
            IndexRule indexRule;
            if (!(rule instanceof IndexRule) || (indexRule = (IndexRule)rule).getPropertyKey() != index.getPropertyKeyId()) continue;
            return indexRule;
        }
        return null;
    }
}

