/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.util.Arrays;
import org.neo4j.kernel.impl.api.UpdateMode;

public class NodePropertyUpdate {
    private final long nodeId;
    private final long propertyKeyId;
    private final Object valueBefore;
    private final Object valueAfter;
    private final UpdateMode updateMode;
    private final long[] labelsBefore;
    private final long[] labelsAfter;
    public static final long[] EMPTY_LONG_ARRAY = new long[0];

    public NodePropertyUpdate(long nodeId, long propertyKeyId, Object valueBefore, long[] labelsBefore, Object valueAfter, long[] labelsAfter) {
        this.nodeId = nodeId;
        this.propertyKeyId = propertyKeyId;
        this.valueBefore = valueBefore;
        this.labelsBefore = labelsBefore;
        this.valueAfter = valueAfter;
        this.labelsAfter = labelsAfter;
        this.updateMode = this.figureOutUpdateMode(valueBefore, valueAfter);
    }

    private UpdateMode figureOutUpdateMode(Object valueBefore, Object valueAfter) {
        boolean afterSet;
        boolean beforeSet = valueBefore != null;
        boolean bl = afterSet = valueAfter != null;
        if (!beforeSet && afterSet) {
            return UpdateMode.ADDED;
        }
        if (beforeSet && afterSet) {
            return UpdateMode.CHANGED;
        }
        if (beforeSet) {
            return UpdateMode.REMOVED;
        }
        throw new IllegalArgumentException("Neither before or after set");
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public long getPropertyKeyId() {
        return this.propertyKeyId;
    }

    public Object getValueBefore() {
        return this.valueBefore;
    }

    public Object getValueAfter() {
        return this.valueAfter;
    }

    public UpdateMode getUpdateMode() {
        return this.updateMode;
    }

    public boolean forLabel(long labelId) {
        return this.updateMode.forLabel(this.labelsBefore, this.labelsAfter, labelId);
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.getClass().getSimpleName() + "[" + this.nodeId + ", prop:" + this.propertyKeyId + " ");
        switch (this.updateMode) {
            case ADDED: {
                result.append("add:").append(this.valueAfter);
                break;
            }
            case CHANGED: {
                result.append("change:").append(this.valueBefore).append(" => ").append(this.valueAfter);
                break;
            }
            case REMOVED: {
                result.append("remove:").append(this.valueBefore);
                break;
            }
            default: {
                throw new IllegalArgumentException(this.updateMode.toString());
            }
        }
        result.append(", labelsBefore:").append(Arrays.toString(this.labelsBefore));
        result.append(", labelsAfter:").append(Arrays.toString(this.labelsAfter));
        return result.append("]").toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.labelsBefore);
        result = 31 * result + Arrays.hashCode(this.labelsAfter);
        result = 31 * result + (int)(this.nodeId ^ this.nodeId >>> 32);
        result = 31 * result + (int)(this.propertyKeyId ^ this.propertyKeyId >>> 32);
        result = 31 * result + this.updateMode.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodePropertyUpdate other = (NodePropertyUpdate)obj;
        return Arrays.equals(this.labelsBefore, other.labelsBefore) && Arrays.equals(this.labelsAfter, other.labelsAfter) && this.nodeId == other.nodeId && this.propertyKeyId == other.propertyKeyId && this.updateMode == other.updateMode && NodePropertyUpdate.propertyValuesEqual(this.valueBefore, other.valueBefore) && NodePropertyUpdate.propertyValuesEqual(this.valueAfter, other.valueAfter);
    }

    public static boolean propertyValuesEqual(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a instanceof int[] && b instanceof int[]) {
            return Arrays.equals((int[])a, (int[])b);
        }
        if (a instanceof boolean[] && b instanceof boolean[]) {
            return Arrays.equals((boolean[])a, (boolean[])b);
        }
        if (a instanceof byte[] && b instanceof byte[]) {
            return Arrays.equals((byte[])a, (byte[])b);
        }
        if (a instanceof Object[] && b instanceof Object[]) {
            return Arrays.equals((Object[])a, (Object[])b);
        }
        return a.equals(b);
    }

    public static NodePropertyUpdate add(long nodeId, long propertyKeyId, Object value, long[] labels) {
        return new NodePropertyUpdate(nodeId, propertyKeyId, null, EMPTY_LONG_ARRAY, value, labels);
    }

    public static NodePropertyUpdate change(long nodeId, long propertyKeyId, Object valueBefore, long[] labelsBefore, Object valueAfter, long[] labelsAfter) {
        return new NodePropertyUpdate(nodeId, propertyKeyId, valueBefore, labelsBefore, valueAfter, labelsAfter);
    }

    public static NodePropertyUpdate remove(long nodeId, long propertyKeyId, Object value, long[] labels) {
        return new NodePropertyUpdate(nodeId, propertyKeyId, value, labels, null, EMPTY_LONG_ARRAY);
    }
}

