/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.constraints;

import org.neo4j.kernel.api.operations.KeyNameLookup;

public class UniquenessConstraint {
    private final long labelId;
    private final long propertyKeyId;

    public UniquenessConstraint(long labelId, long propertyKeyId) {
        this.labelId = labelId;
        this.propertyKeyId = propertyKeyId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            UniquenessConstraint that = (UniquenessConstraint)obj;
            return this.equals(that.labelId, that.propertyKeyId);
        }
        return false;
    }

    public int hashCode() {
        int result = (int)(this.labelId ^ this.labelId >>> 32);
        result = 31 * result + (int)(this.propertyKeyId ^ this.propertyKeyId >>> 32);
        return result;
    }

    public long label() {
        return this.labelId;
    }

    public long property() {
        return this.propertyKeyId;
    }

    public boolean equals(long labelId, long propertyKeyId) {
        return this.labelId == labelId && this.propertyKeyId == propertyKeyId;
    }

    public String toString() {
        return String.format("CONSTRAINT ON ( n:label[%s] ) ASSERT n.property[%s] IS UNIQUE", this.labelId, this.propertyKeyId);
    }

    public String userDescription(KeyNameLookup keyNameLookup) {
        String labelName = keyNameLookup.getLabelName(this.labelId);
        String boundIdentifier = labelName.toLowerCase();
        return String.format("CONSTRAINT ON ( %s:%s ) ASSERT %s.%s IS UNIQUE", boundIdentifier, labelName, boundIdentifier, keyNameLookup.getPropertyKeyName(this.propertyKeyId));
    }
}

