/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.NestingIterator;
import org.neo4j.kernel.StandardExpander;

public final class OrderedByTypeExpander
extends StandardExpander.RegularExpander {
    private final Collection<Pair<RelationshipType, Direction>> orderedTypes;

    public OrderedByTypeExpander() {
        this(Collections.emptyList());
    }

    OrderedByTypeExpander(Collection<Pair<RelationshipType, Direction>> orderedTypes) {
        super(Collections.<Direction, RelationshipType[]>emptyMap());
        this.orderedTypes = orderedTypes;
    }

    @Override
    public StandardExpander add(RelationshipType type, Direction direction) {
        ArrayList<Pair<RelationshipType, Direction>> newTypes = new ArrayList<Pair<RelationshipType, Direction>>(this.orderedTypes);
        newTypes.add(Pair.of(type, direction));
        return new OrderedByTypeExpander(newTypes);
    }

    @Override
    public StandardExpander remove(RelationshipType type) {
        ArrayList<Pair<RelationshipType, Direction>> newTypes = new ArrayList<Pair<RelationshipType, Direction>>();
        for (Pair<RelationshipType, Direction> pair : this.orderedTypes) {
            if (type.name().equals(pair.first().name())) continue;
            newTypes.add(pair);
        }
        return new OrderedByTypeExpander(newTypes);
    }

    @Override
    void buildString(StringBuilder result) {
        result.append(this.orderedTypes.toString());
    }

    @Override
    public StandardExpander reverse() {
        ArrayList<Pair<RelationshipType, Direction>> newTypes = new ArrayList<Pair<RelationshipType, Direction>>();
        for (Pair<RelationshipType, Direction> pair : this.orderedTypes) {
            newTypes.add(Pair.of(pair.first(), pair.other().reverse()));
        }
        return new OrderedByTypeExpander(newTypes);
    }

    @Override
    StandardExpander.RegularExpander createNew(Map<Direction, RelationshipType[]> newTypes) {
        throw new UnsupportedOperationException();
    }

    @Override
    Iterator<Relationship> doExpand(Path path, BranchState state) {
        final Node node = path.endNode();
        return new NestingIterator<Relationship, Pair<RelationshipType, Direction>>(this.orderedTypes.iterator()){

            @Override
            protected Iterator<Relationship> createNestedIterator(Pair<RelationshipType, Direction> entry) {
                RelationshipType type = entry.first();
                Direction dir = entry.other();
                return (dir == Direction.BOTH ? node.getRelationships(type) : node.getRelationships(type, dir)).iterator();
            }
        };
    }
}

