/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.util.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.hibernate.HibernateException;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.ogm.datastore.map.impl.MapAssociationSnapshot;
import org.hibernate.ogm.datastore.spi.Association;
import org.hibernate.ogm.datastore.spi.AssociationContext;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.grid.AssociationKey;
import org.hibernate.ogm.grid.AssociationKeyMetadata;
import org.hibernate.ogm.grid.AssociationKind;
import org.hibernate.ogm.grid.EntityKey;
import org.hibernate.ogm.grid.RowKey;
import org.hibernate.ogm.persister.CollectionPhysicalModel;
import org.hibernate.ogm.persister.EntityKeyBuilder;
import org.hibernate.ogm.persister.OgmCollectionPersister;
import org.hibernate.ogm.persister.OgmEntityPersister;
import org.hibernate.ogm.type.GridType;
import org.hibernate.ogm.util.impl.LogicalPhysicalConverterHelper;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.Type;

public class PropertyMetadataProvider {
    private String tableName;
    private String[] keyColumnNames;
    private GridType keyGridType;
    private Object key;
    private SessionImplementor session;
    private AssociationKey collectionMetadataKey;
    private Association collectionMetadata;
    private Object[] columnValues;
    private GridDialect gridDialect;
    private OgmCollectionPersister collectionPersister;
    private boolean inverse;
    private Type propertyType;
    private String[] rowKeyColumnNames;
    private AssociationContext associationContext;
    private Boolean isBidirectional;
    private AssociationKeyMetadata associationKeyMetadata;

    public PropertyMetadataProvider gridDialect(GridDialect gridDialect) {
        this.gridDialect = gridDialect;
        return this;
    }

    public PropertyMetadataProvider tableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public PropertyMetadataProvider keyColumnNames(String[] keyColumnNames) {
        this.keyColumnNames = keyColumnNames;
        return this;
    }

    public PropertyMetadataProvider keyGridType(GridType keyGridType) {
        this.keyGridType = keyGridType;
        return this;
    }

    public PropertyMetadataProvider session(SessionImplementor session) {
        this.session = session;
        return this;
    }

    public PropertyMetadataProvider key(Object key) {
        this.key = key;
        return this;
    }

    public PropertyMetadataProvider keyColumnValues(Object[] columnValues) {
        this.columnValues = columnValues;
        return this;
    }

    public PropertyMetadataProvider inverse() {
        this.inverse = true;
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AssociationKey getCollectionMetadataKey() {
        if (this.collectionMetadataKey != null) return this.collectionMetadataKey;
        if (this.associationKeyMetadata == null) {
            this.associationKeyMetadata = new AssociationKeyMetadata(this.tableName, this.keyColumnNames);
            this.associationKeyMetadata.setRowKeyColumnNames(this.rowKeyColumnNames);
        } else {
            this.tableName = this.associationKeyMetadata.getTable();
            this.keyColumnNames = this.associationKeyMetadata.getColumnNames();
            this.rowKeyColumnNames = this.associationKeyMetadata.getRowKeyColumnNames();
        }
        Object[] columnValues = this.getKeyColumnValues();
        this.collectionMetadataKey = new AssociationKey(this.associationKeyMetadata, columnValues);
        if (this.collectionPersister != null) {
            EntityKey entityKey;
            if (this.inverse) {
                OgmEntityPersister elementPersister = (OgmEntityPersister)this.collectionPersister.getElementPersister();
                entityKey = EntityKeyBuilder.fromPersister(elementPersister, (Serializable)this.key, this.session);
                this.collectionMetadataKey.setCollectionRole(this.buildCollectionRole(this.collectionPersister));
            } else {
                this.collectionMetadataKey.setCollectionRole(this.getUnqualifiedRole(this.collectionPersister));
                entityKey = EntityKeyBuilder.fromPersister((OgmEntityPersister)this.collectionPersister.getOwnerEntityPersister(), (Serializable)this.key, this.session);
            }
            this.collectionMetadataKey.setOwnerEntityKey(entityKey);
            AssociationKind type = this.collectionPersister.getElementType().isEntityType() ? AssociationKind.ASSOCIATION : AssociationKind.EMBEDDED;
            this.collectionMetadataKey.setAssociationKind(type);
            return this.collectionMetadataKey;
        } else {
            if (this.propertyType == null) throw new AssertionFailure("Cannot detect associated entity metadata: collectionPersister and propertyType are both null");
            this.collectionMetadataKey.setAssociationKind(this.propertyType.isEntityType() ? AssociationKind.ASSOCIATION : AssociationKind.EMBEDDED);
            if (!(this.propertyType instanceof EntityType)) throw new AssertionFailure("Cannot detect associated entity metadata. propertyType is of unexpected type: " + this.propertyType.getClass());
            EntityType entityType = (EntityType)this.propertyType;
            OgmEntityPersister associatedPersister = (OgmEntityPersister)entityType.getAssociatedJoinable(this.session.getFactory());
            EntityKey entityKey = new EntityKey(associatedPersister.getEntityKeyMetadata(), columnValues);
            this.collectionMetadataKey.setOwnerEntityKey(entityKey);
            this.collectionMetadataKey.setCollectionRole(this.getCollectionRoleFromToOne(associatedPersister));
        }
        return this.collectionMetadataKey;
    }

    private String getCollectionRoleFromToOne(OgmEntityPersister associatedPersister) {
        Type[] propertyTypes = associatedPersister.getPropertyTypes();
        String otherSidePropertyName = null;
        for (int index = 0; index < propertyTypes.length; ++index) {
            Type type = propertyTypes[index];
            boolean matching = false;
            if (type.isAssociationType() && type.isCollectionType()) {
                matching = this.isCollectionMatching((CollectionType)type, this.tableName);
            } else if (type.isAssociationType() && !type.isCollectionType()) {
                matching = this.isToOneMatching((Loadable)associatedPersister, index, type);
            }
            if (!matching) continue;
            otherSidePropertyName = associatedPersister.getPropertyNames()[index];
            break;
        }
        return this.processOtherSidePropertyName(otherSidePropertyName);
    }

    private boolean isCollectionMatching(CollectionType type, String primarySideTableName) {
        String collectionRole = type.getRole();
        CollectionPhysicalModel reverseCollectionPersister = (CollectionPhysicalModel)this.session.getFactory().getCollectionPersister(collectionRole);
        boolean isSameTable = primarySideTableName.equals(reverseCollectionPersister.getTableName());
        return isSameTable && Arrays.equals(this.keyColumnNames, reverseCollectionPersister.getKeyColumnNames());
    }

    private String buildCollectionRole(OgmCollectionPersister collectionPersister) {
        String otherSidePropertyName = null;
        Loadable elementPersister = (Loadable)collectionPersister.getElementPersister();
        Type[] propertyTypes = elementPersister.getPropertyTypes();
        for (int index = 0; index < propertyTypes.length; ++index) {
            Type type = propertyTypes[index];
            if (!type.isAssociationType()) continue;
            boolean matching = false;
            if (collectionPersister.isOneToMany() && !type.isCollectionType()) {
                matching = this.isToOneMatching(elementPersister, index, type);
            } else if (!collectionPersister.isOneToMany() && type.isCollectionType()) {
                matching = this.isCollectionMatching((CollectionType)type, collectionPersister.getTableName());
            }
            if (!matching) continue;
            otherSidePropertyName = elementPersister.getPropertyNames()[index];
            break;
        }
        return this.processOtherSidePropertyName(otherSidePropertyName);
    }

    private boolean isToOneMatching(Loadable elementPersister, int index, Type type) {
        OneToOneType oneToOneType;
        String associatedProperty;
        if (((EntityType)type).isOneToOne() && (associatedProperty = (oneToOneType = (OneToOneType)type).getRHSUniqueKeyPropertyName()) != null) {
            OgmEntityPersister mainSidePersister = (OgmEntityPersister)oneToOneType.getAssociatedJoinable(this.session.getFactory());
            try {
                int propertyIndex = mainSidePersister.getPropertyIndex(associatedProperty);
                return mainSidePersister.getPropertyTypes()[propertyIndex] == this.propertyType;
            }
            catch (HibernateException e) {
                // empty catch block
            }
        }
        return Arrays.equals(this.keyColumnNames, elementPersister.getPropertyColumnNames(index));
    }

    private String processOtherSidePropertyName(String otherSidePropertyName) {
        if (otherSidePropertyName != null) {
            this.isBidirectional = Boolean.TRUE;
        } else {
            this.isBidirectional = Boolean.FALSE;
            otherSidePropertyName = this.tableName;
        }
        return otherSidePropertyName;
    }

    private String getUnqualifiedRole(CollectionPersister persister) {
        String entity = persister.getOwnerEntityPersister().getEntityName();
        String role = persister.getRole();
        return role.substring(entity.length() + 1);
    }

    private Object[] getKeyColumnValues() {
        if (this.columnValues == null) {
            this.columnValues = LogicalPhysicalConverterHelper.getColumnsValuesFromObjectValue(this.key, this.keyGridType, this.keyColumnNames, this.session);
        }
        return this.columnValues;
    }

    public Tuple createAndPutAssociationTuple(RowKey rowKey) {
        Tuple associationTuple = this.gridDialect.createTupleAssociation(this.getCollectionMetadataKey(), rowKey);
        this.getCollectionMetadata().put(rowKey, associationTuple);
        return associationTuple;
    }

    public Association getCollectionMetadata() {
        if (this.collectionMetadata == null) {
            AssociationKey key = this.getCollectionMetadataKey();
            if (this.isBidirectional == Boolean.FALSE) {
                this.collectionMetadata = new Association(new MapAssociationSnapshot(Collections.EMPTY_MAP));
            } else {
                this.collectionMetadata = this.gridDialect.getAssociation(key, this.getAssociationContext());
                if (this.collectionMetadata == null) {
                    this.collectionMetadata = this.gridDialect.createAssociation(key);
                }
            }
        }
        return this.collectionMetadata;
    }

    public Association getCollectionMetadataOrNull() {
        if (this.collectionMetadata == null) {
            this.collectionMetadata = this.gridDialect.getAssociation(this.getCollectionMetadataKey(), this.getAssociationContext());
        }
        return this.collectionMetadata;
    }

    public void flushToCache() {
        if (this.isBidirectional != Boolean.FALSE) {
            if (this.getCollectionMetadata().isEmpty()) {
                this.gridDialect.removeAssociation(this.getCollectionMetadataKey());
                this.collectionMetadata = null;
            } else {
                this.gridDialect.updateAssociation(this.getCollectionMetadata(), this.getCollectionMetadataKey());
            }
        }
    }

    public PropertyMetadataProvider collectionPersister(OgmCollectionPersister collectionPersister) {
        this.collectionPersister = collectionPersister;
        return this;
    }

    public PropertyMetadataProvider propertyType(Type type) {
        this.propertyType = type;
        return this;
    }

    public PropertyMetadataProvider rowKeyColumnNames(String[] rowKeyColumnNames) {
        this.rowKeyColumnNames = rowKeyColumnNames;
        return this;
    }

    private AssociationContext getAssociationContext() {
        if (this.associationContext == null) {
            if (this.collectionPersister != null) {
                this.associationContext = this.collectionPersister.getAssociationContext();
            } else {
                ArrayList<String> selectableColumns = new ArrayList<String>(this.rowKeyColumnNames.length);
                for (String column : this.rowKeyColumnNames) {
                    selectableColumns.add(column);
                }
                this.associationContext = new AssociationContext(selectableColumns);
            }
        }
        return this.associationContext;
    }

    public PropertyMetadataProvider associationMetadataKey(AssociationKeyMetadata associationKeyMetadata) {
        this.associationKeyMetadata = associationKeyMetadata;
        return this;
    }
}

