/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.util.impl;

import java.io.Serializable;
import java.util.Arrays;
import javax.transaction.SystemException;
import org.hibernate.HibernateException;
import org.hibernate.TransactionException;
import org.hibernate.hql.internal.ast.QuerySyntaxException;
import org.hibernate.ogm.util.impl.Log;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Serializable,
Log,
BasicLogger {
    private static final long serialVersionUID = 1L;
    private static final String projectCode = "OGM";
    private static final String FQCN = Log_$logger.class.getName();
    private static final String datastoreClassCannotBeFound = "DatastoreManager class [%1$s] cannot be found in classpath try with: %2$s";
    private static final String gridDialectHasNoProperConstrutor = "%1$s has no constructor accepting DatasourceProvider";
    private static final String unableToInitializeInfinispan = "Unable to find or initialize Infinispan CacheManager";
    private static final String doesNotImplementGridDialect = "%1$s property does not implement GridDialect interface";
    private static final String jtaCouldNotDetermineStatus = "Could not determine transaction status";
    private static final String jtaCommitFailed = "JTA transaction commit failed";
    private static final String unableToSetTimeout = "Unable to set transaction timeout to '%1$s'";
    private static final String persistenceXmlNotFoundInClassPath = "Could not find any META-INF/persistence.xml file in the classpath. Unable to build Persistence Unit %1$s";
    private static final String gridDialectPropertyOfUnknownType = "GridDialect property is of unknown type %1$s";
    private static final String querySyntaxException = "Syntax error in query: [%1$s]";
    private static final String createdQuery = "Created query object '%2$s' from HQL/JP-QL query '%1$s'.";
    private static final String unableToMarkTransactionForRollback = "Unable to mark JTA transaction for rollback";
    private static final String givenImplementationClassIsOfWrongType = "Given class %2$s is no implementation/sub-type of %1$s.";
    private static final String jtaRollbackFailed = "JTA transaction rollback failed";
    private static final String illegalDiscrimantorType = "Illegal discriminator type: '%1$s'";
    private static final String noDatastoreConfigured = "hibernate.ogm.datastore.provider has not been defined and no DatastoreManager could be guessed";
    private static final String version = "Hibernate OGM %1$s";
    private static final String useDatastoreProvider = "NoSQL Datastore provider: %1$s";
    private static final String unexpectedDatastoreProvider = "Expected DatastoreProvider %2$s but found %1$s";
    private static final String usingDefaultTransactionFactory = "Use default transaction factory (use a TransactionManager exclusively to pilot the transaction)";
    private static final String unableToConvertStringToDiscriminator = "Could not convert string to discriminator object";
    private static final String unableToInstantiateDatastoreManager = "Cannot instantiate DatastoreManager %1$s";
    private static final String notADatastoreManager = "%1$s is not a subclass of DatastoreManager. Update hibernate.ogm.datastore.provider";
    private static final String unknownDatastoreManagerType = "DatastoreManager property is of unknown type %1$s";
    private static final String jtaTransactionBeginFailed = "JTA transaction begin failed";
    private static final String useGridDialect = "Grid Dialect: %1$s";
    private static final String cannotInstantiateGridDialect = "Cannot instantiate GridDialect class [%1$s]";
    private static final String interruptedBatchIndexing = "Batch indexing was interrupted";
    private static final String unableToInstantiateQueryParserService = "Cannot instantiate query parser service %s.";
    private static final String dialectClassCannotBeFound = "GridDialect class [%1$s] cannot be found in classpath";

    public Log_$logger(Logger log) {
        super(log);
    }

    @Override
    public final HibernateException datastoreClassCannotBeFound(String className, String availableShortcuts) {
        HibernateException result = new HibernateException(String.format("OGM000008: " + this.datastoreClassCannotBeFound$str(), className, availableShortcuts));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String datastoreClassCannotBeFound$str() {
        return datastoreClassCannotBeFound;
    }

    public final HibernateException gridDialectHasNoProperConstrutor(Class dialectClass) {
        HibernateException result = new HibernateException(String.format("OGM000014: " + this.gridDialectHasNoProperConstrutor$str(), dialectClass));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String gridDialectHasNoProperConstrutor$str() {
        return gridDialectHasNoProperConstrutor;
    }

    @Override
    public final HibernateException unableToInitializeInfinispan(RuntimeException e) {
        HibernateException result = new HibernateException(String.format("OGM000004: " + this.unableToInitializeInfinispan$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInitializeInfinispan$str() {
        return unableToInitializeInfinispan;
    }

    @Override
    public final HibernateException doesNotImplementGridDialect(String value) {
        HibernateException result = new HibernateException(String.format("OGM000013: " + this.doesNotImplementGridDialect$str(), value));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String doesNotImplementGridDialect$str() {
        return doesNotImplementGridDialect;
    }

    @Override
    public final TransactionException jtaCouldNotDetermineStatus(SystemException se) {
        TransactionException result = new TransactionException(String.format("OGM000022: " + this.jtaCouldNotDetermineStatus$str(), new Object[0]), (Throwable)se);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jtaCouldNotDetermineStatus$str() {
        return jtaCouldNotDetermineStatus;
    }

    @Override
    public final TransactionException jtaCommitFailed(Exception e) {
        TransactionException result = new TransactionException(String.format("OGM000019: " + this.jtaCommitFailed$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jtaCommitFailed$str() {
        return jtaCommitFailed;
    }

    @Override
    public final TransactionException unableToSetTimeout(SystemException se, int timeout) {
        TransactionException result = new TransactionException(String.format("OGM000023: " + this.unableToSetTimeout$str(), timeout), (Throwable)se);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToSetTimeout$str() {
        return unableToSetTimeout;
    }

    @Override
    public final void persistenceXmlNotFoundInClassPath(String unitName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, "OGM000002: " + this.persistenceXmlNotFoundInClassPath$str(), (Object)unitName);
    }

    protected String persistenceXmlNotFoundInClassPath$str() {
        return persistenceXmlNotFoundInClassPath;
    }

    public final HibernateException gridDialectPropertyOfUnknownType(Class type) {
        HibernateException result = new HibernateException(String.format("OGM000012: " + this.gridDialectPropertyOfUnknownType$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String gridDialectPropertyOfUnknownType$str() {
        return gridDialectPropertyOfUnknownType;
    }

    @Override
    public final HibernateException querySyntaxException(QuerySyntaxException qse, String queryString) {
        HibernateException result = new HibernateException(String.format("OGM000024: " + this.querySyntaxException$str(), queryString), (Throwable)qse);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String querySyntaxException$str() {
        return querySyntaxException;
    }

    @Override
    public final void createdQuery(String hqlQuery, Object queryObject) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, "OGM000028: " + this.createdQuery$str(), (Object)hqlQuery, queryObject);
    }

    protected String createdQuery$str() {
        return createdQuery;
    }

    @Override
    public final TransactionException unableToMarkTransactionForRollback(Exception e) {
        TransactionException result = new TransactionException(String.format("OGM000021: " + this.unableToMarkTransactionForRollback$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToMarkTransactionForRollback$str() {
        return unableToMarkTransactionForRollback;
    }

    @Override
    public final HibernateException givenImplementationClassIsOfWrongType(String expectedClassName, String actualClassName) {
        HibernateException result = new HibernateException(String.format("OGM000029: " + this.givenImplementationClassIsOfWrongType$str(), expectedClassName, actualClassName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String givenImplementationClassIsOfWrongType$str() {
        return givenImplementationClassIsOfWrongType;
    }

    @Override
    public final TransactionException jtaRollbackFailed(Exception e) {
        TransactionException result = new TransactionException(String.format("OGM000020: " + this.jtaRollbackFailed$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jtaRollbackFailed$str() {
        return jtaRollbackFailed;
    }

    @Override
    public final HibernateException illegalDiscrimantorType(String name) {
        HibernateException result = new HibernateException(String.format("OGM000026: " + this.illegalDiscrimantorType$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalDiscrimantorType$str() {
        return illegalDiscrimantorType;
    }

    @Override
    public final HibernateException noDatastoreConfigured() {
        HibernateException result = new HibernateException(String.format("OGM000009: " + this.noDatastoreConfigured$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noDatastoreConfigured$str() {
        return noDatastoreConfigured;
    }

    @Override
    public final void version(String versionString) {
        this.log.logf(FQCN, Logger.Level.INFO, null, "OGM000001: " + this.version$str(), (Object)versionString);
    }

    protected String version$str() {
        return version;
    }

    @Override
    public final void useDatastoreProvider(String datastoreProviderClass) {
        this.log.logf(FQCN, Logger.Level.INFO, null, "OGM000016: " + this.useDatastoreProvider$str(), (Object)datastoreProviderClass);
    }

    protected String useDatastoreProvider$str() {
        return useDatastoreProvider;
    }

    public final HibernateException unexpectedDatastoreProvider(Class found, Class expected) {
        HibernateException result = new HibernateException(String.format("OGM000015: " + this.unexpectedDatastoreProvider$str(), found, expected));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unexpectedDatastoreProvider$str() {
        return unexpectedDatastoreProvider;
    }

    @Override
    public final void usingDefaultTransactionFactory() {
        this.log.logf(FQCN, Logger.Level.INFO, null, "OGM000003: " + this.usingDefaultTransactionFactory$str(), new Object[0]);
    }

    protected String usingDefaultTransactionFactory$str() {
        return usingDefaultTransactionFactory;
    }

    @Override
    public final HibernateException unableToConvertStringToDiscriminator(Exception e) {
        HibernateException result = new HibernateException(String.format("OGM000027: " + this.unableToConvertStringToDiscriminator$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToConvertStringToDiscriminator$str() {
        return unableToConvertStringToDiscriminator;
    }

    @Override
    public final HibernateException unableToInstantiateDatastoreManager(String managerClassName, Exception e) {
        HibernateException result = new HibernateException(String.format("OGM000006: " + this.unableToInstantiateDatastoreManager$str(), managerClassName), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInstantiateDatastoreManager$str() {
        return unableToInstantiateDatastoreManager;
    }

    @Override
    public final HibernateException notADatastoreManager(String propertyValue) {
        HibernateException result = new HibernateException(String.format("OGM000005: " + this.notADatastoreManager$str(), propertyValue));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notADatastoreManager$str() {
        return notADatastoreManager;
    }

    @Override
    public final HibernateException unknownDatastoreManagerType(String managerType) {
        HibernateException result = new HibernateException(String.format("OGM000007: " + this.unknownDatastoreManagerType$str(), managerType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownDatastoreManagerType$str() {
        return unknownDatastoreManagerType;
    }

    @Override
    public final TransactionException jtaTransactionBeginFailed(Exception e) {
        TransactionException result = new TransactionException(String.format("OGM000018: " + this.jtaTransactionBeginFailed$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jtaTransactionBeginFailed$str() {
        return jtaTransactionBeginFailed;
    }

    @Override
    public final void useGridDialect(String gridDialectClass) {
        this.log.logf(FQCN, Logger.Level.INFO, null, "OGM000017: " + this.useGridDialect$str(), (Object)gridDialectClass);
    }

    protected String useGridDialect$str() {
        return useGridDialect;
    }

    public final HibernateException cannotInstantiateGridDialect(Class dialectClass, Exception e) {
        HibernateException result = new HibernateException(String.format("OGM000011: " + this.cannotInstantiateGridDialect$str(), dialectClass), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotInstantiateGridDialect$str() {
        return cannotInstantiateGridDialect;
    }

    @Override
    public final void interruptedBatchIndexing() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, "OGM000025: " + this.interruptedBatchIndexing$str(), new Object[0]);
    }

    protected String interruptedBatchIndexing$str() {
        return interruptedBatchIndexing;
    }

    @Override
    public final HibernateException unableToInstantiateQueryParserService(String parserServiceClassName, Exception e) {
        HibernateException result = new HibernateException(String.format("OGM000030: " + this.unableToInstantiateQueryParserService$str(), parserServiceClassName), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInstantiateQueryParserService$str() {
        return unableToInstantiateQueryParserService;
    }

    @Override
    public final HibernateException dialectClassCannotBeFound(String className) {
        HibernateException result = new HibernateException(String.format("OGM000010: " + this.dialectClassCannotBeFound$str(), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String dialectClassCannotBeFound$str() {
        return dialectClassCannotBeFound;
    }
}

