/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.util.impl;

import javax.transaction.SystemException;
import org.hibernate.HibernateException;
import org.hibernate.TransactionException;
import org.hibernate.hql.internal.ast.QuerySyntaxException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Cause;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageLogger;

@MessageLogger(projectCode="OGM")
public interface Log
extends BasicLogger {
    @LogMessage(level=Logger.Level.INFO)
    @Message(id=1, value="Hibernate OGM %1$s")
    public void version(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=2, value="Could not find any META-INF/persistence.xml file in the classpath. Unable to build Persistence Unit %1$s")
    public void persistenceXmlNotFoundInClassPath(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=3, value="Use default transaction factory (use a TransactionManager exclusively to pilot the transaction)")
    public void usingDefaultTransactionFactory();

    @Message(id=4, value="Unable to find or initialize Infinispan CacheManager")
    public HibernateException unableToInitializeInfinispan(@Cause RuntimeException var1);

    @Message(id=5, value="%1$s is not a subclass of DatastoreManager. Update hibernate.ogm.datastore.provider")
    public HibernateException notADatastoreManager(String var1);

    @Message(id=6, value="Cannot instantiate DatastoreManager %1$s")
    public HibernateException unableToInstantiateDatastoreManager(String var1, @Cause Exception var2);

    @Message(id=7, value="DatastoreManager property is of unknown type %1$s")
    public HibernateException unknownDatastoreManagerType(String var1);

    @Message(id=8, value="DatastoreManager class [%1$s] cannot be found in classpath try with: %2$s")
    public HibernateException datastoreClassCannotBeFound(String var1, String var2);

    @Message(id=9, value="hibernate.ogm.datastore.provider has not been defined and no DatastoreManager could be guessed")
    public HibernateException noDatastoreConfigured();

    @Message(id=10, value="GridDialect class [%1$s] cannot be found in classpath")
    public HibernateException dialectClassCannotBeFound(String var1);

    @Message(id=11, value="Cannot instantiate GridDialect class [%1$s]")
    public HibernateException cannotInstantiateGridDialect(Class<?> var1, @Cause Exception var2);

    @Message(id=12, value="GridDialect property is of unknown type %1$s")
    public HibernateException gridDialectPropertyOfUnknownType(Class<?> var1);

    @Message(id=13, value="%1$s property does not implement GridDialect interface")
    public HibernateException doesNotImplementGridDialect(String var1);

    @Message(id=14, value="%1$s has no constructor accepting DatasourceProvider")
    public HibernateException gridDialectHasNoProperConstrutor(Class<?> var1);

    @Message(id=15, value="Expected DatastoreProvider %2$s but found %1$s")
    public HibernateException unexpectedDatastoreProvider(Class<?> var1, Class<?> var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=16, value="NoSQL Datastore provider: %1$s")
    public void useDatastoreProvider(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=17, value="Grid Dialect: %1$s")
    public void useGridDialect(String var1);

    @Message(id=18, value="JTA transaction begin failed")
    public TransactionException jtaTransactionBeginFailed(@Cause Exception var1);

    @Message(id=19, value="JTA transaction commit failed")
    public TransactionException jtaCommitFailed(@Cause Exception var1);

    @Message(id=20, value="JTA transaction rollback failed")
    public TransactionException jtaRollbackFailed(@Cause Exception var1);

    @Message(id=21, value="Unable to mark JTA transaction for rollback")
    public TransactionException unableToMarkTransactionForRollback(@Cause Exception var1);

    @Message(id=22, value="Could not determine transaction status")
    public TransactionException jtaCouldNotDetermineStatus(@Cause SystemException var1);

    @Message(id=23, value="Unable to set transaction timeout to '%1$s'")
    public TransactionException unableToSetTimeout(@Cause SystemException var1, int var2);

    @Message(id=24, value="Syntax error in query: [%1$s]")
    public HibernateException querySyntaxException(@Cause QuerySyntaxException var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=25, value="Batch indexing was interrupted")
    public void interruptedBatchIndexing();

    @Message(id=26, value="Illegal discriminator type: '%1$s'")
    public HibernateException illegalDiscrimantorType(String var1);

    @Message(id=27, value="Could not convert string to discriminator object")
    public HibernateException unableToConvertStringToDiscriminator(@Cause Exception var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=28, value="Created query object '%2$s' from HQL/JP-QL query '%1$s'.")
    public void createdQuery(String var1, Object var2);

    @Message(id=29, value="Given class %2$s is no implementation/sub-type of %1$s.")
    public HibernateException givenImplementationClassIsOfWrongType(String var1, String var2);

    @Message(id=30, value="Cannot instantiate query parser service %s.")
    public HibernateException unableToInstantiateQueryParserService(String var1, @Cause Exception var2);
}

