/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.type.descriptor;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.hibernate.HibernateException;
import org.hibernate.type.descriptor.java.CalendarDateTypeDescriptor;

public class CalendarTimeZoneDateTimeTypeDescriptor
extends CalendarDateTypeDescriptor {
    public static final CalendarTimeZoneDateTimeTypeDescriptor INSTANCE = new CalendarTimeZoneDateTimeTypeDescriptor();
    private static final String DATE_TIME_TIMEZONE_FORMAT = "yyyy/MM/dd HH:mm:ss:SSS Z";

    public Calendar fromString(String string) {
        GregorianCalendar calendar = new GregorianCalendar();
        try {
            calendar.setTime(this.createDateTimeTimeZoneFormat().parse(string));
        }
        catch (ParseException pe) {
            throw new HibernateException("could not parse date time string", (Throwable)pe);
        }
        return calendar;
    }

    public String toString(Calendar value) {
        return this.createDateTimeTimeZoneFormat().format(value.getTime());
    }

    public boolean areEqual(Calendar one, Calendar another) {
        if (one == another) {
            return true;
        }
        if (one == null || another == null) {
            return false;
        }
        return one.get(5) == another.get(5) && one.get(2) == another.get(2) && one.get(1) == another.get(1) && one.getTimeZone() == another.getTimeZone() && one.getTime() == another.getTime();
    }

    private SimpleDateFormat createDateTimeTimeZoneFormat() {
        SimpleDateFormat dateTimeTimeZoneFormat = new SimpleDateFormat(DATE_TIME_TIMEZONE_FORMAT);
        dateTimeTimeZoneFormat.setLenient(false);
        return dateTimeTimeZoneFormat;
    }
}

