/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.type;

import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.ogm.type.AbstractGenericBasicType;
import org.hibernate.ogm.type.descriptor.PassThroughGridTypeDescriptor;
import org.hibernate.type.descriptor.java.BooleanTypeDescriptor;

public class BooleanType
extends AbstractGenericBasicType<Boolean> {
    public static final BooleanType INSTANCE = new BooleanType();

    public BooleanType() {
        super(PassThroughGridTypeDescriptor.INSTANCE, BooleanTypeDescriptor.INSTANCE);
    }

    @Override
    public String getName() {
        return "boolean";
    }

    @Override
    protected boolean registerUnderJavaType() {
        return true;
    }

    @Override
    public int getColumnSpan(Mapping mapping) throws MappingException {
        return 1;
    }

    @Override
    public String toString(Boolean value) throws HibernateException {
        return value.toString();
    }

    @Override
    public Boolean fromStringValue(String value) throws HibernateException {
        if (Boolean.toString(true).equals(value)) {
            return Boolean.TRUE;
        }
        if (Boolean.toString(false).equals(value)) {
            return Boolean.FALSE;
        }
        throw new HibernateException("Unable to rebuild Boolean from String");
    }
}

