/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.transaction.impl;

import java.util.Map;
import org.hibernate.engine.transaction.internal.TransactionFactoryInitiator;
import org.hibernate.engine.transaction.internal.jdbc.JdbcTransactionFactory;
import org.hibernate.engine.transaction.spi.TransactionFactory;
import org.hibernate.ogm.service.impl.OptionalServiceInitiator;
import org.hibernate.ogm.transaction.impl.JTATransactionManagerTransactionFactory;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.service.spi.BasicServiceInitiator;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class OgmTransactionFactoryInitiator
extends OptionalServiceInitiator<TransactionFactory> {
    public static final OgmTransactionFactoryInitiator INSTANCE = new OgmTransactionFactoryInitiator();
    private static final Log log = LoggerFactory.make();

    public Class<TransactionFactory> getServiceInitiated() {
        return TransactionFactory.class;
    }

    @Override
    protected TransactionFactory buildServiceInstance(Map configurationValues, ServiceRegistryImplementor registry) {
        Object strategy = configurationValues.get("hibernate.transaction.factory_class");
        if (strategy == null || JdbcTransactionFactory.class.getName().equals(strategy)) {
            log.usingDefaultTransactionFactory();
            return new JTATransactionManagerTransactionFactory();
        }
        return TransactionFactoryInitiator.INSTANCE.initiateService(configurationValues, registry);
    }

    @Override
    protected BasicServiceInitiator<TransactionFactory> backupInitiator() {
        return TransactionFactoryInitiator.INSTANCE;
    }
}

