/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.service.impl;

import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.service.impl.QueryParserService;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceInitiator;

class QueryParserServicesInitiator
implements SessionFactoryServiceInitiator<QueryParserService> {
    public static final SessionFactoryServiceInitiator<QueryParserService> INSTANCE = new QueryParserServicesInitiator();
    private static final Log log = LoggerFactory.make();

    QueryParserServicesInitiator() {
    }

    public Class<QueryParserService> getServiceInitiated() {
        return QueryParserService.class;
    }

    public QueryParserService initiateService(SessionFactoryImplementor sessionFactory, Configuration configuration, ServiceRegistryImplementor registry) {
        Class<?> queryParserServiceClass = this.getQueryParserServiceType(configuration, registry);
        if (!QueryParserService.class.isAssignableFrom(queryParserServiceClass)) {
            throw log.givenImplementationClassIsOfWrongType(QueryParserService.class.getName(), queryParserServiceClass.getName());
        }
        try {
            return (QueryParserService)queryParserServiceClass.newInstance();
        }
        catch (Exception e) {
            throw log.unableToInstantiateQueryParserService(queryParserServiceClass.getName(), e);
        }
    }

    private Class<?> getQueryParserServiceType(Configuration configuration, ServiceRegistryImplementor registry) {
        String queryParserOption = configuration.getProperty("hibernate.ogm.query.parser");
        if (queryParserOption != null) {
            return ((ClassLoaderService)registry.getService(ClassLoaderService.class)).classForName(queryParserOption);
        }
        return ((DatastoreProvider)registry.getService(DatastoreProvider.class)).getDefaultQueryParserServiceType();
    }

    public QueryParserService initiateService(SessionFactoryImplementor sessionFactory, MetadataImplementor metadata, ServiceRegistryImplementor registry) {
        throw new UnsupportedOperationException("Cannot create " + QueryParserService.class.getName() + " service using metadata");
    }
}

