/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.service.impl;

import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.ServiceContributingIntegrator;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.ogm.cfg.impl.OgmNamingStrategy;
import org.hibernate.ogm.cfg.impl.Version;
import org.hibernate.ogm.dialect.OgmDialectFactoryInitiator;
import org.hibernate.ogm.jdbc.OgmConnectionProviderInitiator;
import org.hibernate.ogm.jpa.impl.OgmPersisterClassResolverInitiator;
import org.hibernate.ogm.service.impl.ConfigurationService;
import org.hibernate.ogm.service.impl.ConfigurationServiceInitiator;
import org.hibernate.ogm.service.impl.OgmJdbcServicesInitiator;
import org.hibernate.ogm.service.impl.OgmSessionFactoryServiceRegistryFactoryInitiator;
import org.hibernate.ogm.transaction.impl.OgmJtaPlatformInitiator;
import org.hibernate.ogm.transaction.impl.OgmTransactionFactoryInitiator;
import org.hibernate.service.ServiceRegistryBuilder;
import org.hibernate.service.spi.BasicServiceInitiator;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class OgmIntegrator
implements Integrator,
ServiceContributingIntegrator {
    public void integrate(Configuration configuration, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        if (!((ConfigurationService)serviceRegistry.getService(ConfigurationService.class)).isOgmOn()) {
            return;
        }
        Version.touch();
        configuration.setNamingStrategy(OgmNamingStrategy.INSTANCE);
    }

    public void integrate(MetadataImplementor metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        Version.touch();
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }

    public void prepareServices(ServiceRegistryBuilder serviceRegistryBuilder) {
        serviceRegistryBuilder.addInitiator((BasicServiceInitiator)OgmSessionFactoryServiceRegistryFactoryInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((BasicServiceInitiator)ConfigurationServiceInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((BasicServiceInitiator)OgmPersisterClassResolverInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((BasicServiceInitiator)OgmConnectionProviderInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((BasicServiceInitiator)OgmDialectFactoryInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((BasicServiceInitiator)OgmTransactionFactoryInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((BasicServiceInitiator)OgmJtaPlatformInitiator.INSTANCE);
        serviceRegistryBuilder.addInitiator((BasicServiceInitiator)OgmJdbcServicesInitiator.INSTANCE);
    }
}

