/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.massindex;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.hibernate.CacheMode;
import org.hibernate.SessionFactory;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.massindex.batchindexing.BatchCoordinator;
import org.hibernate.ogm.massindex.batchindexing.Executors;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.search.MassIndexer;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.impl.SimpleIndexingProgressMonitor;
import org.hibernate.search.jmx.IndexingProgressMonitor;

public class OgmMassIndexer
implements MassIndexer {
    private static final Log log = LoggerFactory.make();
    private final SearchFactoryImplementor searchFactory;
    private final SessionFactory sessionFactory;
    private final GridDialect gridDialect;
    private int threadsToLoad = 2;
    private int batchSizeToLoad = 10;
    private int threadForSubsequentFetching = 4;
    private MassIndexerProgressMonitor monitor;
    private CacheMode cacheMode = CacheMode.IGNORE;
    private boolean optimizeOnFinish = true;
    private boolean optimizeAfterPurge = true;
    private boolean purgeAllOnStart = true;
    private long maximumIndexedObjects = 10L;
    private int idFetchSize = 100;
    private final Set<Class<?>> rootEntities;

    public OgmMassIndexer(GridDialect gridDialect, SearchFactoryImplementor searchFactory, SessionFactory sessionFactory, Class<?> ... entities) {
        this.gridDialect = gridDialect;
        this.searchFactory = searchFactory;
        this.sessionFactory = sessionFactory;
        this.rootEntities = OgmMassIndexer.toRootEntities(searchFactory, entities);
        this.monitor = this.createMonitor(searchFactory);
    }

    private MassIndexerProgressMonitor createMonitor(SearchFactoryImplementor searchFactory) {
        return searchFactory.isJMXEnabled() ? new IndexingProgressMonitor() : new SimpleIndexingProgressMonitor();
    }

    public MassIndexer threadsToLoadObjects(int numberOfThreads) {
        this.atLeastOneValidation(numberOfThreads);
        this.threadsToLoad = numberOfThreads;
        return this;
    }

    public MassIndexer batchSizeToLoadObjects(int batchSize) {
        this.batchSizeToLoad = batchSize;
        return this;
    }

    public MassIndexer threadsForSubsequentFetching(int numberOfThreads) {
        this.atLeastOneValidation(numberOfThreads);
        this.threadForSubsequentFetching = numberOfThreads;
        return this;
    }

    @Deprecated
    public MassIndexer threadsForIndexWriter(int numberOfThreads) {
        return this;
    }

    public MassIndexer progressMonitor(MassIndexerProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public MassIndexer cacheMode(CacheMode cacheMode) {
        this.cacheMode = cacheMode;
        return this;
    }

    public MassIndexer optimizeOnFinish(boolean optimize) {
        this.optimizeOnFinish = optimize;
        return this;
    }

    public MassIndexer optimizeAfterPurge(boolean optimize) {
        this.optimizeAfterPurge = optimize;
        return this;
    }

    public MassIndexer purgeAllOnStart(boolean purgeAll) {
        this.purgeAllOnStart = purgeAll;
        return this;
    }

    public MassIndexer limitIndexedObjectsTo(long maximum) {
        this.maximumIndexedObjects = maximum;
        return this;
    }

    public MassIndexer idFetchSize(int idFetchSize) {
        this.idFetchSize = idFetchSize;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<?> start() {
        ThreadPoolExecutor executor = Executors.newFixedThreadPool(1, "batch coordinator");
        try {
            Future<?> future = executor.submit(this.createCoordinator());
            return future;
        }
        finally {
            executor.shutdown();
        }
    }

    public void startAndWait() throws InterruptedException {
        BatchCoordinator coordinator = this.createCoordinator();
        coordinator.run();
    }

    protected BatchCoordinator createCoordinator() {
        return new BatchCoordinator(this.gridDialect, this.rootEntities, this.searchFactory, this.sessionFactory, this.threadsToLoad, this.threadForSubsequentFetching, this.cacheMode, this.batchSizeToLoad, this.maximumIndexedObjects, this.optimizeOnFinish, this.purgeAllOnStart, this.optimizeAfterPurge, this.monitor, this.idFetchSize);
    }

    private void atLeastOneValidation(int numberOfThreads) {
        if (numberOfThreads < 1) {
            throw new IllegalArgumentException("numberOfThreads must be at least 1");
        }
    }

    private static Set<Class<?>> toRootEntities(SearchFactoryImplementor searchFactoryImplementor, Class<?> ... selection) {
        HashSet entities = new HashSet();
        for (Class<?> entityType : selection) {
            Set targetedClasses = searchFactoryImplementor.getIndexedTypesPolymorphic(new Class[]{entityType});
            if (targetedClasses.isEmpty()) {
                String msg = entityType.getName() + " is not an indexed entity or a subclass of an indexed entity";
                throw new IllegalArgumentException(msg);
            }
            entities.addAll(targetedClasses);
        }
        HashSet cleaned = new HashSet();
        HashSet<Class> toRemove = new HashSet<Class>();
        for (Class type : entities) {
            boolean typeIsOk = true;
            for (Class clazz : cleaned) {
                if (clazz.isAssignableFrom(type)) {
                    typeIsOk = false;
                    break;
                }
                if (!type.isAssignableFrom(clazz)) continue;
                toRemove.add(clazz);
            }
            if (!typeIsOk) continue;
            cleaned.add(type);
        }
        cleaned.removeAll(toRemove);
        log.debugf("Targets for indexing job: %s", cleaned);
        return cleaned;
    }
}

