/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.jpa.impl;

import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.Metamodel;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.ejb.HibernateEntityManagerFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.spi.EventSource;
import org.hibernate.ogm.exception.NotSupportedException;
import org.hibernate.ogm.hibernatecore.impl.OgmSession;
import org.hibernate.ogm.hibernatecore.impl.OgmSessionFactory;
import org.hibernate.ogm.jpa.impl.LetThroughExecuteUpdateQuery;
import org.hibernate.ogm.jpa.impl.OgmEntityManagerFactory;

public class OgmEntityManager
implements EntityManager {
    private final EntityManager hibernateEm;
    private final OgmEntityManagerFactory factory;

    public OgmEntityManager(OgmEntityManagerFactory factory, EntityManager hibernateEm) {
        this.hibernateEm = hibernateEm;
        this.factory = factory;
    }

    public void persist(Object entity) {
        this.hibernateEm.persist(entity);
    }

    public <T> T merge(T entity) {
        return (T)this.hibernateEm.merge(entity);
    }

    public void remove(Object entity) {
        this.hibernateEm.remove(entity);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        return (T)this.hibernateEm.find(entityClass, primaryKey);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        return (T)this.hibernateEm.find(entityClass, primaryKey, properties);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        return (T)this.hibernateEm.find(entityClass, primaryKey, lockMode);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        return (T)this.hibernateEm.find(entityClass, primaryKey, lockMode, properties);
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        return (T)this.hibernateEm.getReference(entityClass, primaryKey);
    }

    public void flush() {
        this.hibernateEm.flush();
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.hibernateEm.setFlushMode(flushMode);
    }

    public FlushModeType getFlushMode() {
        return this.hibernateEm.getFlushMode();
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.hibernateEm.lock(entity, lockMode);
    }

    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.hibernateEm.lock(entity, lockMode, properties);
    }

    public void refresh(Object entity) {
        this.hibernateEm.refresh(entity);
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        this.hibernateEm.refresh(entity, properties);
    }

    public void refresh(Object entity, LockModeType lockMode) {
        this.hibernateEm.refresh(entity, lockMode);
    }

    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.hibernateEm.refresh(entity, lockMode, properties);
    }

    public void clear() {
        this.hibernateEm.clear();
    }

    public void detach(Object entity) {
        this.hibernateEm.detach(entity);
    }

    public boolean contains(Object entity) {
        return this.hibernateEm.contains(entity);
    }

    public LockModeType getLockMode(Object entity) {
        return this.hibernateEm.getLockMode(entity);
    }

    public void setProperty(String propertyName, Object value) {
        this.hibernateEm.setProperty(propertyName, value);
    }

    public Map<String, Object> getProperties() {
        return this.hibernateEm.getProperties();
    }

    public Query createQuery(String qlString) {
        if (qlString != null && qlString.toLowerCase().startsWith("delete from")) {
            return new LetThroughExecuteUpdateQuery();
        }
        throw new NotSupportedException("OGM-21", "JP-QL queries are not supported yet");
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        throw new NotSupportedException("OGM-8", "criteria queries are not supported yet");
    }

    public <T> TypedQuery<T> createQuery(String qlString, Class<T> resultClass) {
        throw new NotSupportedException("OGM-14", "typed queries are not supported yet");
    }

    public Query createNamedQuery(String name) {
        throw new NotSupportedException("OGM-15", "named queries are not supported yet");
    }

    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        throw new NotSupportedException("OGM-14", "typed queries are not supported yet");
    }

    public Query createNativeQuery(String sqlString) {
        throw new IllegalStateException("Hibernate OGM does not support native queries");
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        throw new IllegalStateException("Hibernate OGM does not support native queries");
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        throw new IllegalStateException("Hibernate OGM does not support native queries");
    }

    public void joinTransaction() {
        this.hibernateEm.joinTransaction();
    }

    public <T> T unwrap(Class<T> cls) {
        Object session = this.hibernateEm.unwrap(cls);
        if (Session.class.isAssignableFrom(cls) || SessionImplementor.class.isAssignableFrom(cls)) {
            return (T)this.buildOgmSession((Session)((EventSource)session));
        }
        throw new HibernateException("Cannot unwrap the following type: " + cls);
    }

    private OgmSession buildOgmSession(Session session) {
        SessionFactory sessionFactory = ((HibernateEntityManagerFactory)this.hibernateEm.getEntityManagerFactory()).getSessionFactory();
        OgmSessionFactory ogmSessionFactory = new OgmSessionFactory((SessionFactoryImplementor)sessionFactory);
        return new OgmSession(ogmSessionFactory, (EventSource)session);
    }

    public Object getDelegate() {
        Object delegate = this.hibernateEm.getDelegate();
        if (Session.class.isAssignableFrom(delegate.getClass())) {
            return this.buildOgmSession((Session)((EventSource)delegate));
        }
        return delegate;
    }

    public void close() {
        this.hibernateEm.close();
    }

    public boolean isOpen() {
        return this.hibernateEm.isOpen();
    }

    public EntityTransaction getTransaction() {
        return this.hibernateEm.getTransaction();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.factory;
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.hibernateEm.getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.hibernateEm.getMetamodel();
    }
}

