/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.jpa;

import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.persistence.spi.ProviderUtil;
import org.hibernate.cfg.EJB3DTDEntityResolver;
import org.hibernate.ejb.HibernatePersistence;
import org.hibernate.ejb.packaging.PersistenceMetadata;
import org.hibernate.ejb.packaging.PersistenceXmlLoader;
import org.hibernate.ogm.cfg.impl.OgmNamingStrategy;
import org.hibernate.ogm.jpa.impl.DelegatorPersistenceUnitInfo;
import org.hibernate.ogm.jpa.impl.OgmEntityManagerFactory;
import org.hibernate.ogm.jpa.impl.OgmIdentifierGeneratorStrategyProvider;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.xml.sax.EntityResolver;

public class HibernateOgmPersistence
implements PersistenceProvider {
    private static final Log log = LoggerFactory.make();
    private static final Map EMPTY_MAP = new HashMap(0);
    private static String IMPLEMENTATION_NAME = HibernateOgmPersistence.class.getName();
    private HibernatePersistence delegate = new HibernatePersistence();

    public EntityManagerFactory createEntityManagerFactory(String emName, Map map) {
        try {
            Map integration = map == null ? EMPTY_MAP : Collections.unmodifiableMap(map);
            Enumeration<URL> persistenceXml = Thread.currentThread().getContextClassLoader().getResources("META-INF/persistence.xml");
            if (!persistenceXml.hasMoreElements()) {
                log.persistenceXmlNotFoundInClassPath(emName != null ? emName : "");
            }
            while (persistenceXml.hasMoreElements()) {
                URL url = persistenceXml.nextElement();
                List metadataFiles = PersistenceXmlLoader.deploy((URL)url, integration, (EntityResolver)new EJB3DTDEntityResolver(), (PersistenceUnitTransactionType)PersistenceUnitTransactionType.RESOURCE_LOCAL);
                for (PersistenceMetadata metadata : metadataFiles) {
                    if (!IMPLEMENTATION_NAME.equalsIgnoreCase(metadata.getProvider())) continue;
                    HashMap<Object, Object> protectiveCopy = new HashMap<Object, Object>(integration);
                    this.enforceOgmConfig(protectiveCopy);
                    protectiveCopy.put("javax.persistence.provider", this.delegate.getClass().getName());
                    EntityManagerFactory coreEMF = this.delegate.createEntityManagerFactory(emName, protectiveCopy);
                    if (coreEMF == null) continue;
                    return new OgmEntityManagerFactory(coreEMF);
                }
            }
            return null;
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new PersistenceException("Unable to build EntityManagerFactory", (Throwable)e);
        }
    }

    private void enforceOgmConfig(Map<Object, Object> map) {
        map.put("hibernate.ejb.naming_strategy", OgmNamingStrategy.class.getName());
        map.put("hibernate.connection.datasource", "---PlaceHolderDSForOGM---");
        map.put("hibernate.ejb.identifier_generator_strategy_provider", OgmIdentifierGeneratorStrategyProvider.class.getName());
        map.put("hibernate.id.new_generator_mappings", "true");
        map.put("hibernate.ogm._activate", "true");
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map map) {
        String persistenceProviderClassName = info.getPersistenceProviderClassName();
        if (persistenceProviderClassName == null || IMPLEMENTATION_NAME.equals(persistenceProviderClassName)) {
            HashMap<Object, Object> protectiveCopy = map != null ? new HashMap<Object, Object>(map) : new HashMap();
            this.enforceOgmConfig(protectiveCopy);
            EntityManagerFactory coreEMF = this.delegate.createContainerEntityManagerFactory((PersistenceUnitInfo)new DelegatorPersistenceUnitInfo(info), protectiveCopy);
            if (coreEMF != null) {
                return new OgmEntityManagerFactory(coreEMF);
            }
        }
        return null;
    }

    public ProviderUtil getProviderUtil() {
        return this.delegate.getProviderUtil();
    }
}

