/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.id.impl;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.MappingException;
import org.hibernate.cfg.ObjectNameNormalizer;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.PersistentIdentifierGenerator;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.id.enhanced.OptimizerFactory;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.jdbc.AbstractReturningWork;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.hibernate.mapping.Table;
import org.hibernate.ogm.datastore.impl.DatastoreServices;
import org.hibernate.ogm.datastore.impl.EmptyTupleSnapshot;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.grid.RowKey;
import org.hibernate.ogm.type.GridType;
import org.hibernate.ogm.type.StringType;
import org.hibernate.ogm.type.TypeTranslator;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;

public class OgmTableGenerator
implements PersistentIdentifierGenerator,
Configurable {
    public static final String CONFIG_PREFER_SEGMENT_PER_ENTITY = "prefer_entity_table_as_segment_value";
    public static final String TABLE_PARAM = "table_name";
    public static final String DEF_TABLE = "hibernate_sequences";
    public static final String VALUE_COLUMN_PARAM = "value_column_name";
    public static final String DEF_VALUE_COLUMN = "next_val";
    public static final String SEGMENT_COLUMN_PARAM = "segment_column_name";
    public static final String DEF_SEGMENT_COLUMN = "sequence_name";
    public static final String SEGMENT_VALUE_PARAM = "segment_value";
    public static final String DEF_SEGMENT_VALUE = "default";
    public static final String SEGMENT_LENGTH_PARAM = "segment_value_length";
    public static final int DEF_SEGMENT_LENGTH = 255;
    public static final String INITIAL_PARAM = "initial_value";
    public static final int DEFAULT_INITIAL_VALUE = 1;
    public static final String INCREMENT_PARAM = "increment_size";
    public static final int DEFAULT_INCREMENT_SIZE = 1;
    public static final String OPT_PARAM = "optimizer";
    private static final Log log = LoggerFactory.make();
    private Type identifierType;
    private String tableName;
    private String segmentColumnName;
    private String segmentValue;
    private int segmentValueLength;
    private String valueColumnName;
    private int initialValue;
    private int incrementSize;
    private String selectQuery;
    private String insertQuery;
    private String updateQuery;
    private Optimizer optimizer;
    private long accessCount = 0L;
    private volatile GridType identifierValueGridType;
    private GridType segmentGridType = StringType.INSTANCE;
    private volatile GridDialect gridDialect;

    public Object generatorKey() {
        return this.tableName;
    }

    public final Type getIdentifierType() {
        return this.identifierType;
    }

    public final String getTableName() {
        return this.tableName;
    }

    public final String getSegmentColumnName() {
        return this.segmentColumnName;
    }

    public final String getSegmentValue() {
        return this.segmentValue;
    }

    public final int getSegmentValueLength() {
        return this.segmentValueLength;
    }

    public final String getValueColumnName() {
        return this.valueColumnName;
    }

    public final int getInitialValue() {
        return this.initialValue;
    }

    public final int getIncrementSize() {
        return this.incrementSize;
    }

    public final Optimizer getOptimizer() {
        return this.optimizer;
    }

    public final long getTableAccessCount() {
        return this.accessCount;
    }

    public void configure(Type type, Properties params, Dialect dialect) throws MappingException {
        this.identifierType = type;
        this.tableName = this.determineGeneratorTableName(params, dialect);
        this.segmentColumnName = this.determineSegmentColumnName(params, dialect);
        this.valueColumnName = this.determineValueColumnName(params, dialect);
        this.segmentValue = this.determineSegmentValue(params);
        this.segmentValueLength = this.determineSegmentColumnSize(params);
        this.initialValue = this.determineInitialValue(params);
        this.incrementSize = this.determineIncrementSize(params);
        String defaultPooledOptimizerStrategy = ConfigurationHelper.getBoolean((String)"hibernate.id.optimizer.pooled.prefer_lo", (Map)params, (boolean)false) ? "pooled-lo" : "pooled";
        String defaultOptimizerStrategy = this.incrementSize <= 1 ? OptimizerFactory.NONE : defaultPooledOptimizerStrategy;
        String optimizationStrategy = ConfigurationHelper.getString((String)OPT_PARAM, (Map)params, (String)defaultOptimizerStrategy);
        this.optimizer = OptimizerFactory.buildOptimizer((String)optimizationStrategy, (Class)this.identifierType.getReturnedClass(), (int)this.incrementSize, (long)ConfigurationHelper.getInt((String)INITIAL_PARAM, (Map)params, (int)-1));
    }

    protected String determineGeneratorTableName(Properties params, Dialect dialect) {
        boolean isGivenNameUnqualified;
        String name = ConfigurationHelper.getString((String)TABLE_PARAM, (Map)params, (String)DEF_TABLE);
        boolean bl = isGivenNameUnqualified = name.indexOf(46) < 0;
        if (isGivenNameUnqualified) {
            ObjectNameNormalizer normalizer = (ObjectNameNormalizer)params.get("identifier_normalizer");
            name = normalizer.normalizeIdentifierQuoting(name);
            String schemaName = normalizer.normalizeIdentifierQuoting(params.getProperty("schema"));
            String catalogName = normalizer.normalizeIdentifierQuoting(params.getProperty("catalog"));
            name = Table.qualify((String)dialect.quote(catalogName), (String)dialect.quote(schemaName), (String)dialect.quote(name));
        }
        return name;
    }

    protected String determineSegmentColumnName(Properties params, Dialect dialect) {
        ObjectNameNormalizer normalizer = (ObjectNameNormalizer)params.get("identifier_normalizer");
        String name = ConfigurationHelper.getString((String)SEGMENT_COLUMN_PARAM, (Map)params, (String)DEF_SEGMENT_COLUMN);
        return dialect.quote(normalizer.normalizeIdentifierQuoting(name));
    }

    protected String determineValueColumnName(Properties params, Dialect dialect) {
        ObjectNameNormalizer normalizer = (ObjectNameNormalizer)params.get("identifier_normalizer");
        String name = ConfigurationHelper.getString((String)VALUE_COLUMN_PARAM, (Map)params, (String)DEF_VALUE_COLUMN);
        return dialect.quote(normalizer.normalizeIdentifierQuoting(name));
    }

    protected String determineSegmentValue(Properties params) {
        String segmentValue = params.getProperty(SEGMENT_VALUE_PARAM);
        if (StringHelper.isEmpty((String)segmentValue)) {
            segmentValue = this.determineDefaultSegmentValue(params);
        }
        return segmentValue;
    }

    protected String determineDefaultSegmentValue(Properties params) {
        boolean preferSegmentPerEntity = ConfigurationHelper.getBoolean((String)CONFIG_PREFER_SEGMENT_PER_ENTITY, (Map)params, (boolean)false);
        String defaultToUse = preferSegmentPerEntity ? params.getProperty("target_table") : DEF_SEGMENT_VALUE;
        log.info("explicit segment value for id generator [" + this.tableName + '.' + this.segmentColumnName + "] suggested; using default [" + defaultToUse + "]");
        return defaultToUse;
    }

    protected int determineSegmentColumnSize(Properties params) {
        return ConfigurationHelper.getInt((String)SEGMENT_LENGTH_PARAM, (Map)params, (int)255);
    }

    protected int determineInitialValue(Properties params) {
        return ConfigurationHelper.getInt((String)INITIAL_PARAM, (Map)params, (int)1);
    }

    protected int determineIncrementSize(Properties params) {
        return ConfigurationHelper.getInt((String)INCREMENT_PARAM, (Map)params, (int)1);
    }

    protected String buildSelectQuery(Dialect dialect) {
        String alias = "tbl";
        String query = "select " + StringHelper.qualify((String)"tbl", (String)this.valueColumnName) + " from " + this.tableName + ' ' + "tbl" + " where " + StringHelper.qualify((String)"tbl", (String)this.segmentColumnName) + "=?";
        LockOptions lockOptions = new LockOptions(LockMode.PESSIMISTIC_WRITE);
        lockOptions.setAliasSpecificLockMode("tbl", LockMode.PESSIMISTIC_WRITE);
        Map<String, String[]> updateTargetColumnsMap = Collections.singletonMap("tbl", new String[]{this.valueColumnName});
        return dialect.applyLocksToSql(query, lockOptions, updateTargetColumnsMap);
    }

    protected String buildUpdateQuery() {
        return "update " + this.tableName + " set " + this.valueColumnName + "=? " + " where " + this.valueColumnName + "=? and " + this.segmentColumnName + "=?";
    }

    protected String buildInsertQuery() {
        return "insert into " + this.tableName + " (" + this.segmentColumnName + ", " + this.valueColumnName + ") " + " values (?,?)";
    }

    public synchronized Serializable generate(final SessionImplementor session, Object obj) {
        return this.optimizer.generate(new AccessCallback(){

            public IntegralDataTypeHolder getNextValue() {
                return (IntegralDataTypeHolder)OgmTableGenerator.this.doWorkInIsolationTransaction(session);
            }
        });
    }

    public Serializable doWorkInIsolationTransaction(final SessionImplementor session) throws HibernateException {
        boolean workInTransaction = false;
        class Work
        extends AbstractReturningWork<IntegralDataTypeHolder> {
            private SessionImplementor localSession;

            Work() {
                this.localSession = session;
            }

            public IntegralDataTypeHolder execute(Connection connection) throws SQLException {
                try {
                    return OgmTableGenerator.this.doWorkInCurrentTransactionIfAny(this.localSession);
                }
                catch (RuntimeException sqle) {
                    throw new HibernateException("Could not get or update next value", (Throwable)sqle);
                }
            }
        }
        Work work = new Work();
        Serializable generatedValue = (Serializable)session.getTransactionCoordinator().getTransaction().createIsolationDelegate().delegateWork((WorkExecutorVisitable)work, workInTransaction);
        return generatedValue;
    }

    public IntegralDataTypeHolder doWorkInCurrentTransactionIfAny(SessionImplementor session) {
        this.defineGridTypes(session);
        Object segmentColumnValue = this.nullSafeSet(this.segmentGridType, this.segmentValue, this.segmentColumnName, session);
        RowKey key = new RowKey(this.tableName, new String[]{this.segmentColumnName}, new Object[]{segmentColumnValue});
        GridDialect dialect = this.getDialect(session);
        IntegralDataTypeHolder value = IdentifierGeneratorHelper.getIntegralDataTypeHolder((Class)this.identifierType.getReturnedClass());
        dialect.nextValue(key, value, this.optimizer.applyIncrementSizeToSourceValues() ? this.incrementSize : 1, this.initialValue);
        ++this.accessCount;
        return value;
    }

    private GridDialect getDialect(SessionImplementor session) {
        if (this.gridDialect == null) {
            this.gridDialect = ((DatastoreServices)session.getFactory().getServiceRegistry().getService(DatastoreServices.class)).getGridDialect();
        }
        return this.gridDialect;
    }

    private Object nullSafeSet(GridType type, Object value, String columnName, SessionImplementor session) {
        Tuple tuple = new Tuple(EmptyTupleSnapshot.SINGLETON);
        type.nullSafeSet(tuple, value, new String[]{columnName}, session);
        return tuple.get(columnName);
    }

    private void defineGridTypes(SessionImplementor session) {
        if (this.identifierValueGridType == null) {
            ServiceRegistryImplementor registry = session.getFactory().getServiceRegistry();
            this.identifierValueGridType = ((TypeTranslator)registry.getService(TypeTranslator.class)).getType((Type)new LongType());
        }
    }

    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return new String[0];
    }

    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        return new String[0];
    }
}

