/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.hibernatecore.impl;

import java.sql.Connection;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.Interceptor;
import org.hibernate.SessionBuilder;
import org.hibernate.SharedSessionBuilder;
import org.hibernate.event.spi.EventSource;
import org.hibernate.ogm.hibernatecore.impl.OgmSession;
import org.hibernate.ogm.hibernatecore.impl.OgmSessionFactory;

public class OgmSharedSessionBuilderDelegator
implements SharedSessionBuilder {
    private final SharedSessionBuilder builder;
    private final OgmSessionFactory factory;

    public OgmSharedSessionBuilderDelegator(SharedSessionBuilder builder, OgmSessionFactory factory) {
        this.builder = builder;
        this.factory = factory;
    }

    public SharedSessionBuilder interceptor() {
        this.builder.interceptor();
        return this;
    }

    public SharedSessionBuilder connection() {
        this.builder.connection();
        return this;
    }

    public SharedSessionBuilder connectionReleaseMode() {
        this.builder.connectionReleaseMode();
        return this;
    }

    public SharedSessionBuilder autoJoinTransactions() {
        this.builder.autoJoinTransactions();
        return this;
    }

    public SharedSessionBuilder autoClose() {
        this.builder.autoClose();
        return this;
    }

    public SharedSessionBuilder flushBeforeCompletion() {
        this.builder.flushBeforeCompletion();
        return this;
    }

    public SharedSessionBuilder transactionContext() {
        this.builder.transactionContext();
        return this;
    }

    public OgmSession openSession() {
        return new OgmSession(this.factory, (EventSource)this.builder.openSession());
    }

    public SharedSessionBuilder interceptor(Interceptor interceptor) {
        this.builder.interceptor(interceptor);
        return this;
    }

    public SharedSessionBuilder noInterceptor() {
        this.builder.noInterceptor();
        return this;
    }

    public SharedSessionBuilder connection(Connection connection) {
        this.builder.connection(connection);
        return this;
    }

    public SharedSessionBuilder connectionReleaseMode(ConnectionReleaseMode connectionReleaseMode) {
        this.builder.connectionReleaseMode(connectionReleaseMode);
        return this;
    }

    public SharedSessionBuilder autoJoinTransactions(boolean autoJoinTransactions) {
        this.builder.autoJoinTransactions(autoJoinTransactions);
        return this;
    }

    public SharedSessionBuilder autoClose(boolean autoClose) {
        this.builder.autoClose(autoClose);
        return this;
    }

    public SharedSessionBuilder flushBeforeCompletion(boolean flushBeforeCompletion) {
        this.builder.flushBeforeCompletion(flushBeforeCompletion);
        return this;
    }

    public SessionBuilder tenantIdentifier(String tenantIdentifier) {
        this.builder.tenantIdentifier(tenantIdentifier);
        return this;
    }
}

