/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.hibernatecore.impl;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.Filter;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.IdentifierLoadAccess;
import org.hibernate.Interceptor;
import org.hibernate.LobHelper;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.NaturalIdLoadAccess;
import org.hibernate.Query;
import org.hibernate.ReplicationMode;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionException;
import org.hibernate.SharedSessionBuilder;
import org.hibernate.SimpleNaturalIdLoadAccess;
import org.hibernate.Transaction;
import org.hibernate.TypeHelper;
import org.hibernate.UnknownProfileException;
import org.hibernate.cache.spi.CacheKey;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.jdbc.spi.JdbcConnectionAccess;
import org.hibernate.engine.query.spi.HQLQueryPlan;
import org.hibernate.engine.query.spi.ParameterMetadata;
import org.hibernate.engine.query.spi.sql.NativeSQLQuerySpecification;
import org.hibernate.engine.spi.ActionQueue;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.NonFlushedChanges;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.hibernate.event.spi.EventSource;
import org.hibernate.hql.internal.ast.QuerySyntaxException;
import org.hibernate.internal.CriteriaImpl;
import org.hibernate.jdbc.ReturningWork;
import org.hibernate.jdbc.Work;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.ogm.exception.NotSupportedException;
import org.hibernate.ogm.hibernatecore.impl.OgmQuery;
import org.hibernate.ogm.hibernatecore.impl.OgmSessionFactory;
import org.hibernate.ogm.hibernatecore.impl.OgmSharedSessionBuilderDelegator;
import org.hibernate.ogm.service.impl.QueryParserService;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.stat.SessionStatistics;
import org.hibernate.type.Type;

public class OgmSession
implements Session,
EventSource {
    private static final Log log = LoggerFactory.make();
    private final EventSource delegate;
    private final OgmSessionFactory factory;
    private QueryParserService queryParserService;

    public OgmSession(OgmSessionFactory factory, EventSource delegate) {
        this.delegate = delegate;
        this.factory = factory;
    }

    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    public OgmSessionFactory getSessionFactory() {
        return this.factory;
    }

    public Criteria createCriteria(Class persistentClass) {
        throw new NotSupportedException("OGM-23", "Criteria queries are not supported yet");
    }

    public Criteria createCriteria(Class persistentClass, String alias) {
        throw new NotSupportedException("OGM-23", "Criteria queries are not supported yet");
    }

    public Criteria createCriteria(String entityName) {
        throw new NotSupportedException("OGM-23", "Criteria queries are not supported yet");
    }

    public Criteria createCriteria(String entityName, String alias) {
        throw new NotSupportedException("OGM-23", "Criteria queries are not supported yet");
    }

    public Query createQuery(String queryString) throws HibernateException {
        this.errorIfClosed();
        Map enabledFilters = Collections.EMPTY_MAP;
        try {
            HQLQueryPlan plan = new HQLQueryPlan(queryString, false, enabledFilters, (SessionFactoryImplementor)this.factory);
            ParameterMetadata parameterMetadata = plan.getParameterMetadata();
            OgmQuery query = new OgmQuery(queryString, this.getFlushMode(), this, parameterMetadata, this.getQueryParserService());
            query.setComment(queryString);
            return query;
        }
        catch (QuerySyntaxException qse) {
            throw log.querySyntaxException(qse, queryString);
        }
    }

    private QueryParserService getQueryParserService() {
        if (this.queryParserService == null) {
            this.queryParserService = (QueryParserService)this.getSessionFactory().getServiceRegistry().getService(QueryParserService.class);
        }
        return this.queryParserService;
    }

    public SQLQuery createSQLQuery(String queryString) throws HibernateException {
        throw new IllegalStateException("Hibernate OGM does not support native queries");
    }

    public Query createFilter(Object collection, String queryString) throws HibernateException {
        throw new NotSupportedException("OGM-24", "filters are not supported yet");
    }

    public Filter enableFilter(String filterName) {
        throw new NotSupportedException("OGM-25", "filters are not supported yet");
    }

    public Filter getEnabledFilter(String filterName) {
        return this.delegate.getEnabledFilter(filterName);
    }

    public void disableFilter(String filterName) {
        throw new NotSupportedException("OGM-25", "filters are not supported yet");
    }

    public void doWork(Work work) throws HibernateException {
        throw new IllegalStateException("Hibernate OGM does not support SQL Connections hence no Work");
    }

    public <T> T doReturningWork(ReturningWork<T> work) throws HibernateException {
        return (T)this.delegate.doReturningWork(work);
    }

    public ActionQueue getActionQueue() {
        return this.delegate.getActionQueue();
    }

    public Object instantiate(EntityPersister persister, Serializable id) throws HibernateException {
        return this.delegate.instantiate(persister, id);
    }

    public void forceFlush(EntityEntry e) throws HibernateException {
        this.delegate.forceFlush(e);
    }

    public void merge(String entityName, Object object, Map copiedAlready) throws HibernateException {
        this.delegate.merge(entityName, object, copiedAlready);
    }

    public void persist(String entityName, Object object, Map createdAlready) throws HibernateException {
        this.delegate.persist(entityName, object, createdAlready);
    }

    public void persistOnFlush(String entityName, Object object, Map copiedAlready) {
        this.delegate.persistOnFlush(entityName, object, copiedAlready);
    }

    public void refresh(Object object, Map refreshedAlready) throws HibernateException {
        this.delegate.refresh(object, refreshedAlready);
    }

    public void delete(String entityName, Object child, boolean isCascadeDeleteEnabled, Set transientEntities) {
        this.delegate.delete(entityName, child, isCascadeDeleteEnabled, transientEntities);
    }

    public JdbcConnectionAccess getJdbcConnectionAccess() {
        return this.delegate.getJdbcConnectionAccess();
    }

    public EntityKey generateEntityKey(Serializable id, EntityPersister persister) {
        return this.delegate.generateEntityKey(id, persister);
    }

    public CacheKey generateCacheKey(Serializable id, Type type, String entityOrRoleName) {
        return this.delegate.generateCacheKey(id, type, entityOrRoleName);
    }

    public Interceptor getInterceptor() {
        return this.delegate.getInterceptor();
    }

    public void setAutoClear(boolean enabled) {
        this.delegate.setAutoClear(enabled);
    }

    public void disableTransactionAutoJoin() {
        this.delegate.disableTransactionAutoJoin();
    }

    public boolean isTransactionInProgress() {
        return this.delegate.isTransactionInProgress();
    }

    public void initializeCollection(PersistentCollection collection, boolean writing) throws HibernateException {
        this.delegate.initializeCollection(collection, writing);
    }

    public Object internalLoad(String entityName, Serializable id, boolean eager, boolean nullable) throws HibernateException {
        return this.delegate.internalLoad(entityName, id, eager, nullable);
    }

    public Object immediateLoad(String entityName, Serializable id) throws HibernateException {
        return this.delegate.immediateLoad(entityName, id);
    }

    public long getTimestamp() {
        return this.delegate.getTimestamp();
    }

    public List list(String query, QueryParameters queryParameters) throws HibernateException {
        return this.delegate.list(query, queryParameters);
    }

    public Iterator iterate(String query, QueryParameters queryParameters) throws HibernateException {
        return this.delegate.iterate(query, queryParameters);
    }

    public ScrollableResults scroll(String query, QueryParameters queryParameters) throws HibernateException {
        return this.delegate.scroll(query, queryParameters);
    }

    public ScrollableResults scroll(CriteriaImpl criteria, ScrollMode scrollMode) {
        return this.delegate.scroll(criteria, scrollMode);
    }

    public List list(CriteriaImpl criteria) {
        return this.delegate.list(criteria);
    }

    public List listFilter(Object collection, String filter, QueryParameters queryParameters) throws HibernateException {
        return this.delegate.listFilter(collection, filter, queryParameters);
    }

    public Iterator iterateFilter(Object collection, String filter, QueryParameters queryParameters) throws HibernateException {
        return this.delegate.iterateFilter(collection, filter, queryParameters);
    }

    public EntityPersister getEntityPersister(String entityName, Object object) throws HibernateException {
        return this.delegate.getEntityPersister(entityName, object);
    }

    public Object getEntityUsingInterceptor(EntityKey key) throws HibernateException {
        return this.delegate.getEntityUsingInterceptor(key);
    }

    public Serializable getContextEntityIdentifier(Object object) {
        return this.delegate.getContextEntityIdentifier(object);
    }

    public String bestGuessEntityName(Object object) {
        return this.delegate.bestGuessEntityName(object);
    }

    public String guessEntityName(Object entity) throws HibernateException {
        return this.delegate.guessEntityName(entity);
    }

    public Object instantiate(String entityName, Serializable id) throws HibernateException {
        return this.delegate.instantiate(entityName, id);
    }

    public List listCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        return this.delegate.listCustomQuery(customQuery, queryParameters);
    }

    public ScrollableResults scrollCustomQuery(CustomQuery customQuery, QueryParameters queryParameters) throws HibernateException {
        return this.delegate.scrollCustomQuery(customQuery, queryParameters);
    }

    public List list(NativeSQLQuerySpecification spec, QueryParameters queryParameters) throws HibernateException {
        return this.delegate.list(spec, queryParameters);
    }

    public ScrollableResults scroll(NativeSQLQuerySpecification spec, QueryParameters queryParameters) throws HibernateException {
        return this.delegate.scroll(spec, queryParameters);
    }

    public Object getFilterParameterValue(String filterParameterName) {
        return this.delegate.getFilterParameterValue(filterParameterName);
    }

    public Type getFilterParameterType(String filterParameterName) {
        return this.delegate.getFilterParameterType(filterParameterName);
    }

    public Map getEnabledFilters() {
        return this.delegate.getEnabledFilters();
    }

    public int getDontFlushFromFind() {
        return this.delegate.getDontFlushFromFind();
    }

    public PersistenceContext getPersistenceContext() {
        return this.delegate.getPersistenceContext();
    }

    public int executeUpdate(String query, QueryParameters queryParameters) throws HibernateException {
        return this.delegate.executeUpdate(query, queryParameters);
    }

    public int executeNativeUpdate(NativeSQLQuerySpecification specification, QueryParameters queryParameters) throws HibernateException {
        return this.delegate.executeNativeUpdate(specification, queryParameters);
    }

    public NonFlushedChanges getNonFlushedChanges() throws HibernateException {
        return this.delegate.getNonFlushedChanges();
    }

    public void applyNonFlushedChanges(NonFlushedChanges nonFlushedChanges) throws HibernateException {
        this.delegate.applyNonFlushedChanges(nonFlushedChanges);
    }

    public Query getNamedQuery(String name) {
        return this.delegate.getNamedQuery(name);
    }

    public Query getNamedSQLQuery(String name) {
        return this.delegate.getNamedSQLQuery(name);
    }

    public boolean isEventSource() {
        return this.delegate.isEventSource();
    }

    public void afterScrollOperation() {
        this.delegate.afterScrollOperation();
    }

    public String getFetchProfile() {
        return this.delegate.getFetchProfile();
    }

    public void setFetchProfile(String name) {
        this.delegate.setFetchProfile(name);
    }

    public TransactionCoordinator getTransactionCoordinator() {
        return this.delegate.getTransactionCoordinator();
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public LoadQueryInfluencers getLoadQueryInfluencers() {
        return this.delegate.getLoadQueryInfluencers();
    }

    public CacheMode getCacheMode() {
        return this.delegate.getCacheMode();
    }

    public void setCacheMode(CacheMode cm) {
        this.delegate.setCacheMode(cm);
    }

    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    public boolean isConnected() {
        return this.delegate.isConnected();
    }

    public FlushMode getFlushMode() {
        return this.delegate.getFlushMode();
    }

    public void setFlushMode(FlushMode fm) {
        this.delegate.setFlushMode(fm);
    }

    public Connection connection() {
        return this.delegate.connection();
    }

    public SharedSessionBuilder sessionWithOptions() {
        return new OgmSharedSessionBuilderDelegator(this.delegate.sessionWithOptions(), this.factory);
    }

    public void flush() {
        this.delegate.flush();
    }

    public Connection close() throws HibernateException {
        return this.delegate.close();
    }

    public void cancelQuery() throws HibernateException {
        this.delegate.cancelQuery();
    }

    public boolean isDirty() throws HibernateException {
        return this.delegate.isDirty();
    }

    public boolean isDefaultReadOnly() {
        return this.delegate.isDefaultReadOnly();
    }

    public void setDefaultReadOnly(boolean readOnly) {
        this.delegate.setDefaultReadOnly(readOnly);
    }

    public Serializable getIdentifier(Object object) throws HibernateException {
        return this.delegate.getIdentifier(object);
    }

    public boolean contains(Object object) {
        return this.delegate.contains(object);
    }

    public void evict(Object object) throws HibernateException {
        this.delegate.evict(object);
    }

    public Object load(Class theClass, Serializable id, LockMode lockMode) throws HibernateException {
        return this.delegate.load(theClass, id, lockMode);
    }

    public Object load(Class theClass, Serializable id, LockOptions lockOptions) throws HibernateException {
        return this.delegate.load(theClass, id, lockOptions);
    }

    public Object load(String entityName, Serializable id, LockMode lockMode) throws HibernateException {
        return this.delegate.load(entityName, id, lockMode);
    }

    public Object load(String entityName, Serializable id, LockOptions lockOptions) throws HibernateException {
        return this.delegate.load(entityName, id, lockOptions);
    }

    public Object load(Class theClass, Serializable id) throws HibernateException {
        return this.delegate.load(theClass, id);
    }

    public Object load(String entityName, Serializable id) throws HibernateException {
        return this.delegate.load(entityName, id);
    }

    public void load(Object object, Serializable id) throws HibernateException {
        this.delegate.load(object, id);
    }

    public void replicate(Object object, ReplicationMode replicationMode) throws HibernateException {
        this.delegate.replicate(object, replicationMode);
    }

    public void replicate(String entityName, Object object, ReplicationMode replicationMode) throws HibernateException {
        this.delegate.replicate(entityName, object, replicationMode);
    }

    public Serializable save(Object object) throws HibernateException {
        return this.delegate.save(object);
    }

    public Serializable save(String entityName, Object object) throws HibernateException {
        return this.delegate.save(entityName, object);
    }

    public void saveOrUpdate(Object object) throws HibernateException {
        this.delegate.saveOrUpdate(object);
    }

    public void saveOrUpdate(String entityName, Object object) throws HibernateException {
        this.delegate.saveOrUpdate(entityName, object);
    }

    public void update(Object object) throws HibernateException {
        this.delegate.update(object);
    }

    public void update(String entityName, Object object) throws HibernateException {
        this.delegate.update(entityName, object);
    }

    public Object merge(Object object) throws HibernateException {
        return this.delegate.merge(object);
    }

    public Object merge(String entityName, Object object) throws HibernateException {
        return this.delegate.merge(entityName, object);
    }

    public void persist(Object object) throws HibernateException {
        this.delegate.persist(object);
    }

    public void persist(String entityName, Object object) throws HibernateException {
        this.delegate.persist(entityName, object);
    }

    public void delete(Object object) throws HibernateException {
        this.delegate.delete(object);
    }

    public void delete(String entityName, Object object) throws HibernateException {
        this.delegate.delete(entityName, object);
    }

    public void lock(Object object, LockMode lockMode) throws HibernateException {
        this.delegate.lock(object, lockMode);
    }

    public void lock(String entityName, Object object, LockMode lockMode) throws HibernateException {
        this.delegate.lock(entityName, object, lockMode);
    }

    public Session.LockRequest buildLockRequest(LockOptions lockOptions) {
        return this.delegate.buildLockRequest(lockOptions);
    }

    public void refresh(Object object) throws HibernateException {
        this.delegate.refresh(object);
    }

    public void refresh(String entityName, Object object) throws HibernateException {
        this.delegate.refresh(entityName, object);
    }

    public void refresh(Object object, LockMode lockMode) throws HibernateException {
        this.delegate.refresh(object, lockMode);
    }

    public void refresh(Object object, LockOptions lockOptions) throws HibernateException {
        this.delegate.refresh(object, lockOptions);
    }

    public void refresh(String entityName, Object object, LockOptions lockOptions) throws HibernateException {
        this.delegate.refresh(entityName, object, lockOptions);
    }

    public LockMode getCurrentLockMode(Object object) throws HibernateException {
        return this.delegate.getCurrentLockMode(object);
    }

    public String getTenantIdentifier() {
        return this.delegate.getTenantIdentifier();
    }

    public Transaction beginTransaction() throws HibernateException {
        return this.delegate.beginTransaction();
    }

    public Transaction getTransaction() {
        return this.delegate.getTransaction();
    }

    public void clear() {
        this.delegate.clear();
    }

    public Object get(Class clazz, Serializable id) throws HibernateException {
        return this.delegate.get(clazz, id);
    }

    public Object get(Class clazz, Serializable id, LockMode lockMode) throws HibernateException {
        return this.delegate.get(clazz, id, lockMode);
    }

    public Object get(Class clazz, Serializable id, LockOptions lockOptions) throws HibernateException {
        return this.delegate.get(clazz, id, lockOptions);
    }

    public Object get(String entityName, Serializable id) throws HibernateException {
        return this.delegate.get(entityName, id);
    }

    public Object get(String entityName, Serializable id, LockMode lockMode) throws HibernateException {
        return this.delegate.get(entityName, id, lockMode);
    }

    public Object get(String entityName, Serializable id, LockOptions lockOptions) throws HibernateException {
        return this.delegate.get(entityName, id, lockOptions);
    }

    public String getEntityName(Object object) throws HibernateException {
        return this.delegate.getEntityName(object);
    }

    public SessionStatistics getStatistics() {
        return this.delegate.getStatistics();
    }

    public boolean isReadOnly(Object entityOrProxy) {
        return this.delegate.isReadOnly(entityOrProxy);
    }

    public void setReadOnly(Object entityOrProxy, boolean readOnly) {
        this.delegate.setReadOnly(entityOrProxy, readOnly);
    }

    public Connection disconnect() throws HibernateException {
        return this.delegate.disconnect();
    }

    public void reconnect(Connection connection) throws HibernateException {
        this.delegate.reconnect(connection);
    }

    public boolean isFetchProfileEnabled(String name) throws UnknownProfileException {
        return this.delegate.isFetchProfileEnabled(name);
    }

    public void enableFetchProfile(String name) throws UnknownProfileException {
        this.delegate.enableFetchProfile(name);
    }

    public void disableFetchProfile(String name) throws UnknownProfileException {
        this.delegate.disableFetchProfile(name);
    }

    public TypeHelper getTypeHelper() {
        return this.delegate.getTypeHelper();
    }

    public LobHelper getLobHelper() {
        return this.delegate.getLobHelper();
    }

    public <T> T execute(LobCreationContext.Callback<T> callback) {
        return (T)this.delegate.execute(callback);
    }

    public IdentifierLoadAccess byId(Class entityClass) {
        return this.delegate.byId(entityClass);
    }

    public IdentifierLoadAccess byId(String entityName) {
        return this.delegate.byId(entityName);
    }

    public NaturalIdLoadAccess byNaturalId(String entityName) {
        return this.delegate.byNaturalId(entityName);
    }

    public NaturalIdLoadAccess byNaturalId(Class entityClass) {
        return this.delegate.byNaturalId(entityClass);
    }

    public SimpleNaturalIdLoadAccess bySimpleNaturalId(String entityName) {
        return this.delegate.bySimpleNaturalId(entityName);
    }

    public SimpleNaturalIdLoadAccess bySimpleNaturalId(Class entityClass) {
        return this.delegate.bySimpleNaturalId(entityClass);
    }

    protected void errorIfClosed() {
        if (this.delegate.isClosed()) {
            throw new SessionException("Session is closed!");
        }
    }
}

