/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.grid.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.grid.RowKey;

public class RowKeyBuilder {
    private List<String> columnNames = new ArrayList<String>();
    private Map<String, Object> values;
    private String tableName;
    private Tuple tuple;

    public RowKeyBuilder addColumns(String ... columns) {
        for (String columnName : columns) {
            this.columnNames.add(columnName);
        }
        return this;
    }

    public RowKeyBuilder values(Map<String, Object> values) {
        this.values = values;
        return this;
    }

    public RowKeyBuilder tableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public RowKey build() {
        String[] columnNamesArray = this.columnNames.toArray(new String[this.columnNames.size()]);
        int length = columnNamesArray.length;
        Object[] columnValuesArray = new Object[length];
        if (this.values != null) {
            for (int index = 0; index < length; ++index) {
                columnValuesArray[index] = this.values.get(columnNamesArray[index]);
            }
        } else {
            for (int index = 0; index < length; ++index) {
                columnValuesArray[index] = this.tuple.get(columnNamesArray[index]);
            }
        }
        return new RowKey(this.tableName, columnNamesArray, columnValuesArray);
    }

    public RowKeyBuilder values(Tuple tuple) {
        this.tuple = tuple;
        return this;
    }

    public String[] getColumnNames() {
        return this.columnNames.toArray(new String[this.columnNames.size()]);
    }
}

