/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.grid;

import java.io.Serializable;
import java.util.Arrays;

public class EntityKeyMetadata
implements Serializable {
    private final String table;
    private final int hashCode;
    private String[] columnNames;

    public EntityKeyMetadata(String tableName, String[] columnNames) {
        this.table = tableName;
        this.columnNames = columnNames;
        this.hashCode = this.generateHashCode();
    }

    public String getTable() {
        return this.table;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EntityKeyMetadata");
        sb.append("{table='").append(this.table).append('\'');
        sb.append(", columnNames=").append(this.columnNames == null ? "null" : Arrays.asList(this.columnNames).toString());
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || EntityKeyMetadata.class != o.getClass()) {
            return false;
        }
        EntityKeyMetadata entityKeyMetadata = (EntityKeyMetadata)o;
        if (!this.table.equals(entityKeyMetadata.table)) {
            return false;
        }
        return Arrays.equals(this.columnNames, entityKeyMetadata.columnNames);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int generateHashCode() {
        int result = this.table.hashCode();
        return result;
    }
}

