/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.grid;

import java.io.Serializable;
import java.util.Arrays;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.ogm.grid.AssociationKeyMetadata;
import org.hibernate.ogm.grid.AssociationKind;
import org.hibernate.ogm.grid.EntityKey;

public final class AssociationKey
implements Serializable {
    private final AssociationKeyMetadata metadata;
    private final Object[] columnValues;
    private final int hashCode;
    private transient String collectionRole;
    private transient EntityKey entityKey;
    private transient AssociationKind associationKind;

    public AssociationKey(AssociationKeyMetadata metadata, Object[] columnValues) {
        this.metadata = metadata;
        if (metadata.getColumnNames().length != columnValues.length) {
            throw new AssertionFailure("Column names do not match column values");
        }
        this.columnValues = columnValues;
        this.hashCode = metadata.hashCode() * 31 + Arrays.hashCode(columnValues);
    }

    public String getTable() {
        return this.metadata.getTable();
    }

    public String[] getColumnNames() {
        return this.metadata.getColumnNames();
    }

    public Object[] getColumnValues() {
        return this.columnValues;
    }

    public String getCollectionRole() {
        return this.collectionRole;
    }

    public EntityKey getEntityKey() {
        return this.entityKey;
    }

    public AssociationKind getAssociationKind() {
        return this.associationKind;
    }

    public String[] getRowKeyColumnNames() {
        return this.metadata.getRowKeyColumnNames();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || AssociationKey.class != o.getClass()) {
            return false;
        }
        AssociationKey that = (AssociationKey)o;
        if (!this.metadata.getTable().equals(that.metadata.getTable())) {
            return false;
        }
        if (!Arrays.equals(this.columnValues, that.columnValues)) {
            return false;
        }
        return Arrays.equals(this.metadata.getColumnNames(), that.metadata.getColumnNames());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AssociationKey");
        sb.append("{table='").append(this.metadata.getTable()).append('\'');
        String[] columnNames = this.metadata.getColumnNames();
        sb.append(", columnNames=").append(columnNames == null ? "null" : Arrays.asList(columnNames).toString());
        sb.append(", columnValues=").append(this.columnValues == null ? "null" : Arrays.asList(this.columnValues).toString());
        sb.append('}');
        return sb.toString();
    }

    public void setCollectionRole(String role) {
        this.collectionRole = role;
    }

    public void setOwnerEntityKey(EntityKey entityKey) {
        this.entityKey = entityKey;
    }

    public void setAssociationKind(AssociationKind kind) {
        this.associationKind = kind;
    }
}

