/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.impl;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.dialect.GridDialectLogger;
import org.hibernate.ogm.dialect.impl.GridDialectFactory;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.classloading.spi.ClassLoaderService;

public class GridDialectFactoryImpl
implements GridDialectFactory {
    private static final Log log = LoggerFactory.make();
    private DatastoreProvider datastore;

    public GridDialectFactoryImpl(DatastoreProvider datastore) {
        this.datastore = datastore;
    }

    @Override
    public GridDialect buildGridDialect(Map configurationValues, ServiceRegistry registry) {
        Object value = configurationValues.get("hibernate.ogm.datastore.grid_dialect");
        Class<? extends GridDialect> dialectClass = this.dialectClass(registry, value);
        return this.buildDialect(registry, dialectClass);
    }

    private GridDialect buildDialect(ServiceRegistry registry, Class<? extends GridDialect> dialectClass) {
        try {
            Constructor<?> injector = null;
            for (Constructor<?> constructor : dialectClass.getConstructors()) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length != 1 || !DatastoreProvider.class.isAssignableFrom(parameterTypes[0])) continue;
                injector = constructor;
                break;
            }
            if (injector == null) {
                log.gridDialectHasNoProperConstrutor(dialectClass);
            }
            GridDialect gridDialect = (GridDialect)injector.newInstance(this.datastore);
            log.useGridDialect(gridDialect.getClass().getName());
            if (GridDialectLogger.activationNeeded()) {
                gridDialect = new GridDialectLogger(gridDialect);
                log.info("Grid dialect logs are active");
            } else {
                log.info("Grid dialect logs are disabled");
            }
            return gridDialect;
        }
        catch (Exception e) {
            throw log.cannotInstantiateGridDialect(dialectClass, e);
        }
    }

    private Class<? extends GridDialect> dialectClass(ServiceRegistry registry, Object value) {
        if (value == null) {
            return this.datastore.getDefaultDialect();
        }
        if (value instanceof String) {
            return this.findGridDialect(registry, value.toString());
        }
        throw log.gridDialectPropertyOfUnknownType(value.getClass());
    }

    private Class<? extends GridDialect> findGridDialect(ServiceRegistry registry, String value) {
        Class<? extends GridDialect> maybeDialectClass = this.loadClass(registry, value);
        if (GridDialect.class.isAssignableFrom(maybeDialectClass)) {
            return maybeDialectClass;
        }
        throw log.doesNotImplementGridDialect(value.toString());
    }

    private Class<? extends GridDialect> loadClass(ServiceRegistry registry, String value) {
        try {
            return ((ClassLoaderService)registry.getService(ClassLoaderService.class)).classForName(value);
        }
        catch (RuntimeException e) {
            throw log.dialectClassCannotBeFound(value.toString());
        }
    }
}

