/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.datastore.impl.SetFromCollection;
import org.hibernate.ogm.datastore.spi.TupleOperation;
import org.hibernate.ogm.datastore.spi.TupleOperationType;
import org.hibernate.ogm.datastore.spi.TupleSnapshot;

public class Tuple {
    private final TupleSnapshot snapshot;
    private Map<String, TupleOperation> currentState = null;

    public Tuple(TupleSnapshot snapshot) {
        this.snapshot = snapshot;
    }

    public Object get(String column) {
        if (this.currentState == null) {
            return this.snapshot.get(column);
        }
        TupleOperation result = this.currentState.get(column);
        if (result == null) {
            return this.snapshot.get(column);
        }
        if (result.getType() == TupleOperationType.PUT_NULL || result.getType() == TupleOperationType.REMOVE) {
            return null;
        }
        return result.getValue();
    }

    public void put(String column, Object value) {
        if (this.currentState == null) {
            this.currentState = new HashMap<String, TupleOperation>();
        }
        if (value == null) {
            this.currentState.put(column, new TupleOperation(column, null, TupleOperationType.PUT_NULL));
        } else {
            this.currentState.put(column, new TupleOperation(column, value, TupleOperationType.PUT));
        }
    }

    public void remove(String column) {
        if (this.currentState == null) {
            this.currentState = new HashMap<String, TupleOperation>();
        }
        this.currentState.put(column, new TupleOperation(column, null, TupleOperationType.REMOVE));
    }

    public Set<TupleOperation> getOperations() {
        if (this.currentState == null) {
            return Collections.emptySet();
        }
        return new SetFromCollection<TupleOperation>(this.currentState.values());
    }

    public TupleSnapshot getSnapshot() {
        return this.snapshot;
    }

    public Set<String> getColumnNames() {
        if (this.currentState == null) {
            return this.snapshot.getColumnNames();
        }
        HashSet<String> columnNames = new HashSet<String>(this.snapshot.getColumnNames());
        for (TupleOperation op : this.currentState.values()) {
            switch (op.getType()) {
                case PUT: 
                case PUT_NULL: {
                    columnNames.add(op.getColumn());
                    break;
                }
                case REMOVE: {
                    columnNames.remove(op.getColumn());
                }
            }
        }
        return columnNames;
    }
}

