/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.datastore.spi.AssociationOperation;
import org.hibernate.ogm.datastore.spi.AssociationOperationType;
import org.hibernate.ogm.datastore.spi.AssociationSnapshot;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.grid.RowKey;

public class Association {
    private final AssociationSnapshot snapshot;
    private final Map<RowKey, AssociationOperation> currentState = new HashMap<RowKey, AssociationOperation>();
    private boolean cleared;

    public Association(AssociationSnapshot snapshot) {
        this.snapshot = snapshot;
    }

    public Tuple get(RowKey key) {
        AssociationOperation result = this.currentState.get(key);
        if (result == null) {
            return this.cleared ? null : this.snapshot.get(key);
        }
        if (result.getType() == AssociationOperationType.PUT_NULL || result.getType() == AssociationOperationType.REMOVE) {
            return null;
        }
        return result.getValue();
    }

    public void put(RowKey key, Tuple value) {
        if (value == null) {
            this.currentState.put(key, new AssociationOperation(key, null, AssociationOperationType.PUT_NULL));
        }
        this.currentState.put(key, new AssociationOperation(key, value, AssociationOperationType.PUT));
    }

    public void remove(RowKey key) {
        this.currentState.put(key, new AssociationOperation(key, null, AssociationOperationType.REMOVE));
    }

    public List<AssociationOperation> getOperations() {
        ArrayList<AssociationOperation> result = new ArrayList<AssociationOperation>();
        if (this.cleared) {
            result.add(new AssociationOperation(null, null, AssociationOperationType.CLEAR));
        }
        result.addAll(this.currentState.values());
        return result;
    }

    public AssociationSnapshot getSnapshot() {
        return this.snapshot;
    }

    public boolean isEmpty() {
        int snapshotSize;
        int n = snapshotSize = this.cleared ? 0 : this.snapshot.size();
        if (snapshotSize == 0 && this.currentState.isEmpty()) {
            return true;
        }
        if (snapshotSize > this.currentState.size()) {
            return false;
        }
        return this.size() == 0;
    }

    public int size() {
        int size = this.cleared ? 0 : this.snapshot.size();
        for (Map.Entry<RowKey, AssociationOperation> op : this.currentState.entrySet()) {
            switch (op.getValue().getType()) {
                case PUT: 
                case PUT_NULL: {
                    if (!this.cleared && this.snapshot.containsKey(op.getKey())) break;
                    ++size;
                    break;
                }
                case REMOVE: {
                    if (this.cleared || !this.snapshot.containsKey(op.getKey())) break;
                    --size;
                }
            }
        }
        return size;
    }

    public Set<RowKey> getKeys() {
        HashSet<RowKey> keys = new HashSet<RowKey>();
        if (!this.cleared) {
            keys.addAll(this.snapshot.getRowKeys());
        }
        for (Map.Entry<RowKey, AssociationOperation> op : this.currentState.entrySet()) {
            switch (op.getValue().getType()) {
                case PUT: 
                case PUT_NULL: {
                    keys.add(op.getKey());
                    break;
                }
                case REMOVE: {
                    keys.remove(op.getKey());
                }
            }
        }
        return keys;
    }

    public void clear() {
        this.cleared = true;
        this.currentState.clear();
    }
}

