/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.map.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.persistence.PessimisticLockException;
import org.hibernate.ogm.datastore.map.impl.HashMapDialect;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.grid.AssociationKey;
import org.hibernate.ogm.grid.EntityKey;
import org.hibernate.ogm.grid.RowKey;
import org.hibernate.ogm.service.impl.LuceneBasedQueryParserService;
import org.hibernate.ogm.service.impl.QueryParserService;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;

public final class MapDatastoreProvider
implements DatastoreProvider,
Startable,
Stoppable {
    private static final Log log = LoggerFactory.make();
    private final ConcurrentMap<EntityKey, Map<String, Object>> entitiesKeyValueStorage = new ConcurrentHashMap<EntityKey, Map<String, Object>>();
    private final ConcurrentMap<AssociationKey, Map<RowKey, Map<String, Object>>> associationsKeyValueStorage = new ConcurrentHashMap<AssociationKey, Map<RowKey, Map<String, Object>>>();
    private final ConcurrentMap<RowKey, AtomicInteger> sequencesStorage = new ConcurrentHashMap<RowKey, AtomicInteger>();
    private final ConcurrentMap<Object, ReadWriteLock> dataLocks = new ConcurrentHashMap<Object, ReadWriteLock>();
    private final ThreadLocal<Set<Lock>> acquiredLocksPerThread = new ThreadLocal<Set<Lock>>(){

        @Override
        protected Set<Lock> initialValue() {
            return new HashSet<Lock>();
        }
    };

    @Override
    public Class<? extends GridDialect> getDefaultDialect() {
        return HashMapDialect.class;
    }

    @Override
    public Class<? extends QueryParserService> getDefaultQueryParserServiceType() {
        return LuceneBasedQueryParserService.class;
    }

    public void stop() {
        this.entitiesKeyValueStorage.clear();
        log.debug("Stopped and cleared MapDatastoreProvider");
    }

    public void start() {
        log.debug("MapDatastoreProvider started");
    }

    public void writeLock(EntityKey key, int timeout) {
        ReadWriteLock lock = this.getLock(key);
        Lock writeLock = lock.writeLock();
        this.acquireLock(key, timeout, writeLock);
    }

    public void readLock(EntityKey key, int timeout) {
        ReadWriteLock lock = this.getLock(key);
        Lock readLock = lock.readLock();
        this.acquireLock(key, timeout, readLock);
    }

    private ReadWriteLock getLock(EntityKey key) {
        ReentrantReadWriteLock newLock = new ReentrantReadWriteLock();
        ReadWriteLock previous = this.dataLocks.putIfAbsent(key, newLock);
        return previous != null ? previous : newLock;
    }

    private void acquireLock(EntityKey key, int timeout, Lock writeLock) {
        try {
            if (timeout == -1) {
                writeLock.lockInterruptibly();
            } else if (timeout == 0) {
                boolean locked = writeLock.tryLock();
                if (!locked) {
                    throw new PessimisticLockException("lock on key " + key + " was not available");
                }
            } else {
                writeLock.tryLock(timeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            throw new PessimisticLockException("timed out waiting for lock on key " + key, (Throwable)e);
        }
        this.acquiredLocksPerThread.get().add(writeLock);
    }

    public void putEntity(EntityKey key, Map<String, Object> tuple) {
        this.entitiesKeyValueStorage.put(key, tuple);
    }

    public Map<String, Object> getEntityTuple(EntityKey key) {
        return (Map)this.entitiesKeyValueStorage.get(key);
    }

    public void removeEntityTuple(EntityKey key) {
        this.entitiesKeyValueStorage.remove(key);
    }

    public void putAssociation(AssociationKey key, Map<RowKey, Map<String, Object>> associationMap) {
        this.associationsKeyValueStorage.put(key, associationMap);
    }

    public Map<RowKey, Map<String, Object>> getAssociation(AssociationKey key) {
        return (Map)this.associationsKeyValueStorage.get(key);
    }

    public void removeAssociation(AssociationKey key) {
        this.associationsKeyValueStorage.remove(key);
    }

    public int getSharedAtomicInteger(RowKey key, int initialValue, int increment) {
        AtomicInteger valueProposal = new AtomicInteger(initialValue);
        AtomicInteger previous = this.sequencesStorage.putIfAbsent(key, valueProposal);
        return previous == null ? initialValue : previous.addAndGet(increment);
    }

    public Map<EntityKey, Map<String, Object>> getEntityMap() {
        return Collections.unmodifiableMap(this.entitiesKeyValueStorage);
    }

    public Map<AssociationKey, Map<RowKey, Map<String, Object>>> getAssociationsMap() {
        return Collections.unmodifiableMap(this.associationsKeyValueStorage);
    }
}

