/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.ogm.datastore.impl.EmptyTupleSnapshot;
import org.hibernate.ogm.datastore.impl.MapTupleSnapshot;
import org.hibernate.ogm.datastore.map.impl.MapAssociationSnapshot;
import org.hibernate.ogm.datastore.spi.Association;
import org.hibernate.ogm.datastore.spi.AssociationOperation;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.datastore.spi.TupleOperation;
import org.hibernate.ogm.datastore.spi.TupleSnapshot;
import org.hibernate.ogm.grid.AssociationKey;
import org.hibernate.ogm.grid.RowKey;

public final class MapHelpers {
    private MapHelpers() {
    }

    public static void applyTupleOpsOnMap(Tuple tuple, Map<String, Object> map) {
        for (TupleOperation action : tuple.getOperations()) {
            switch (action.getType()) {
                case PUT_NULL: 
                case PUT: {
                    map.put(action.getColumn(), action.getValue());
                    break;
                }
                case REMOVE: {
                    map.remove(action.getColumn());
                }
            }
        }
    }

    public static Map<String, Object> tupleToMap(Tuple tuple) {
        if (tuple == null) {
            return null;
        }
        TupleSnapshot snapshotInstance = tuple.getSnapshot();
        Map<String, Object> snapshot = snapshotInstance == EmptyTupleSnapshot.SINGLETON ? Collections.EMPTY_MAP : ((MapTupleSnapshot)snapshotInstance).getMap();
        HashMap<String, Object> map = new HashMap<String, Object>(snapshot);
        MapHelpers.applyTupleOpsOnMap(tuple, map);
        return map;
    }

    public static void updateAssociation(Association association, AssociationKey key) {
        Map<RowKey, Map<String, Object>> atomicMap = ((MapAssociationSnapshot)association.getSnapshot()).getUnderlyingMap();
        for (AssociationOperation action : association.getOperations()) {
            switch (action.getType()) {
                case CLEAR: {
                    atomicMap.clear();
                }
                case PUT_NULL: 
                case PUT: {
                    atomicMap.put(action.getKey(), MapHelpers.tupleToMap(action.getValue()));
                    break;
                }
                case REMOVE: {
                    atomicMap.remove(action.getKey());
                }
            }
        }
    }
}

