/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.impl;

import java.util.Arrays;
import java.util.Map;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.source.MetadataImplementor;
import org.hibernate.ogm.datastore.impl.AvailableDatastoreProvider;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.classloading.spi.ClassLoadingException;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceInitiator;

public final class DatastoreProviderInitiator
implements SessionFactoryServiceInitiator<DatastoreProvider> {
    public static final String DATASTORE_PROVIDER = "hibernate.ogm.datastore.provider";
    public static final DatastoreProviderInitiator INSTANCE = new DatastoreProviderInitiator();
    private static final Log log = LoggerFactory.make();
    private static final String DEFAULT_DATASTORE_PROVIDER_CLASS = "org.hibernate.ogm.datastore.infinispan.impl.InfinispanDatastoreProvider";

    public Class<DatastoreProvider> getServiceInitiated() {
        return DatastoreProvider.class;
    }

    public DatastoreProvider initiateService(SessionFactoryImplementor sessionFactory, Configuration configuration, ServiceRegistryImplementor registry) {
        DatastoreProvider datastoreProvider = this.createDatastoreProvider(configuration.getProperties(), registry);
        log.useDatastoreProvider(datastoreProvider.getClass().getName());
        return datastoreProvider;
    }

    public DatastoreProvider initiateService(SessionFactoryImplementor sessionFactory, MetadataImplementor metadata, ServiceRegistryImplementor registry) {
        throw new UnsupportedOperationException("Cannot create " + DatastoreProvider.class.getName() + " service using metadata");
    }

    private DatastoreProvider createDatastoreProvider(Map<?, ?> configuration, ServiceRegistryImplementor registry) {
        Object datastoreProviderProperty = configuration.get(DATASTORE_PROVIDER);
        if (datastoreProviderProperty == null) {
            return this.defaultDatastoreProvider(registry);
        }
        if (datastoreProviderProperty instanceof DatastoreProvider) {
            return (DatastoreProvider)datastoreProviderProperty;
        }
        if (datastoreProviderProperty instanceof String) {
            return this.createDatastore(registry, (String)datastoreProviderProperty);
        }
        if (datastoreProviderProperty instanceof Class) {
            return this.create((Class)datastoreProviderProperty);
        }
        throw log.unknownDatastoreManagerType(datastoreProviderProperty.getClass().getName());
    }

    private DatastoreProvider createDatastore(ServiceRegistryImplementor registry, String managerProperty) {
        Class<?> dataStoreProviderClass = this.findDataStoreProviderClass(registry, managerProperty);
        return this.create(dataStoreProviderClass);
    }

    private DatastoreProvider create(Class<?> datastoreProviderClass) {
        try {
            this.validate(datastoreProviderClass);
            return (DatastoreProvider)datastoreProviderClass.newInstance();
        }
        catch (InstantiationException e) {
            throw log.unableToInstantiateDatastoreManager(datastoreProviderClass.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw log.unableToInstantiateDatastoreManager(datastoreProviderClass.getName(), e);
        }
    }

    private DatastoreProvider defaultDatastoreProvider(ServiceRegistryImplementor registry) {
        try {
            ClassLoaderService service = (ClassLoaderService)registry.getService(ClassLoaderService.class);
            Class datastoreProviderClass = service.classForName(DEFAULT_DATASTORE_PROVIDER_CLASS);
            return (DatastoreProvider)datastoreProviderClass.newInstance();
        }
        catch (ClassLoadingException e) {
            throw log.noDatastoreConfigured();
        }
        catch (InstantiationException e) {
            throw log.unableToInstantiateDatastoreManager(DEFAULT_DATASTORE_PROVIDER_CLASS, e);
        }
        catch (IllegalAccessException e) {
            throw log.unableToInstantiateDatastoreManager(DEFAULT_DATASTORE_PROVIDER_CLASS, e);
        }
    }

    private void validate(Class<?> datastoreProviderClass) {
        if (!DatastoreProvider.class.isAssignableFrom(datastoreProviderClass)) {
            throw log.notADatastoreManager(datastoreProviderClass.getName());
        }
    }

    private Class<?> findDataStoreProviderClass(ServiceRegistryImplementor registry, String managerPropertyValue) {
        try {
            String datastoreProviderClassName = this.dataStoreProviderClassName(managerPropertyValue);
            return ((ClassLoaderService)registry.getService(ClassLoaderService.class)).classForName(datastoreProviderClassName);
        }
        catch (Exception e) {
            throw log.datastoreClassCannotBeFound(managerPropertyValue, Arrays.toString((Object[])AvailableDatastoreProvider.values()));
        }
    }

    private String dataStoreProviderClassName(String managerPropertyValue) {
        if (this.isValidShortcut(managerPropertyValue)) {
            return AvailableDatastoreProvider.valueOf(managerPropertyValue.toUpperCase()).getDatastoreProviderClassName();
        }
        return managerPropertyValue;
    }

    private boolean isValidShortcut(String shortcut) {
        for (AvailableDatastoreProvider provider : AvailableDatastoreProvider.values()) {
            if (!provider.name().equalsIgnoreCase(shortcut)) continue;
            return true;
        }
        return false;
    }
}

