/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.cfg;

import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.ogm.cfg.impl.OgmNamingStrategy;
import org.hibernate.ogm.hibernatecore.impl.OgmSessionFactory;

public class OgmConfiguration
extends Configuration {
    public static final String OGM_ON = "hibernate.ogm._activate";
    public static final String OGM_QUERY_PARSER_SERVICE = "hibernate.ogm.query.parser";

    public OgmConfiguration() {
        this.resetOgm();
    }

    private void resetOgm() {
        super.setNamingStrategy(OgmNamingStrategy.INSTANCE);
        this.setProperty(OGM_ON, "true");
        this.setProperty("hibernate.search.massindexer.factoryclass", "org.hibernate.ogm.massindex.OgmMassIndexerFactory");
    }

    public SessionFactory buildSessionFactory() throws HibernateException {
        return new OgmSessionFactory((SessionFactoryImplementor)super.buildSessionFactory());
    }

    public Configuration setProperties(Properties properties) {
        super.setProperties(properties);
        if (!properties.containsKey(OGM_ON)) {
            this.setProperty(OGM_ON, "true");
        }
        return this;
    }
}

