/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.mongodb.util;

import java.util.regex.Pattern;

public class LikeExpressionToRegExpConverter {
    private final Character escapeCharacter;

    public LikeExpressionToRegExpConverter() {
        this(null);
    }

    public LikeExpressionToRegExpConverter(Character escapeCharacter) {
        this.escapeCharacter = escapeCharacter;
    }

    public Pattern getRegExpFromLikeExpression(String likeExpression) {
        StringBuilder pattern = new StringBuilder("^");
        State state = State.INITIAL;
        for (int i = 0; i < likeExpression.length(); ++i) {
            char character = likeExpression.charAt(i);
            state = state.handleCharacter(Character.valueOf(character), this.escapeCharacter, pattern);
        }
        if (state == State.PATTERN) {
            pattern.append("\\E");
        }
        pattern.append("$");
        return Pattern.compile(pattern.toString(), 32);
    }

    private static enum State {
        INITIAL,
        ESCAPE,
        PATTERN,
        WILDCARD_CHARACTER;


        private State handleCharacter(Character character, Character escapeCharacter, StringBuilder result) {
            switch (this) {
                case INITIAL: {
                    if (Character.valueOf(character.charValue()).equals(escapeCharacter)) {
                        return ESCAPE;
                    }
                    if (character.charValue() == '%') {
                        result.append(".*");
                        return WILDCARD_CHARACTER;
                    }
                    if (character.charValue() == '_') {
                        result.append(".");
                        return WILDCARD_CHARACTER;
                    }
                    result.append("\\Q");
                    result.append(character);
                    return PATTERN;
                }
                case PATTERN: {
                    if (Character.valueOf(character.charValue()).equals(escapeCharacter)) {
                        return ESCAPE;
                    }
                    if (character.charValue() == '%') {
                        result.append("\\E");
                        result.append(".*");
                        return WILDCARD_CHARACTER;
                    }
                    if (character.charValue() == '_') {
                        result.append("\\E");
                        result.append(".");
                        return WILDCARD_CHARACTER;
                    }
                    result.append(character);
                    return PATTERN;
                }
                case ESCAPE: {
                    result.append(character);
                    return PATTERN;
                }
                case WILDCARD_CHARACTER: {
                    if (Character.valueOf(character.charValue()).equals(escapeCharacter)) {
                        return ESCAPE;
                    }
                    if (character.charValue() == '%') {
                        result.append(".*");
                        return WILDCARD_CHARACTER;
                    }
                    if (character.charValue() == '_') {
                        result.append(".");
                        return WILDCARD_CHARACTER;
                    }
                    result.append("\\Q");
                    result.append(character);
                    return PATTERN;
                }
            }
            throw new IllegalStateException("Unsupported parsing state");
        }
    }
}

