/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Collection;
import java.util.Collections;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.ogm.datastore.mongodb.AssociationStorage;
import org.hibernate.ogm.grid.AssociationKey;
import org.hibernate.ogm.grid.AssociationKind;

public class MongoHelpers {
    public static DBObject associationKeyToObject(AssociationStorage storage, AssociationKey key) {
        if (MongoHelpers.isEmbeddedInEntity(key, storage)) {
            throw new AssertionFailure(MongoHelpers.class.getName() + ".associationKeyToObject should not be called for associations embedded in entity documents");
        }
        Object[] columnValues = key.getColumnValues();
        BasicDBObject columns = new BasicDBObject(columnValues.length);
        int i = 0;
        for (String name : key.getColumnNames()) {
            columns.put(name, columnValues[i++]);
        }
        BasicDBObject idObject = new BasicDBObject(1);
        if (storage == AssociationStorage.GLOBAL_COLLECTION) {
            columns.put("table", (Object)key.getTable());
        }
        idObject.put("_id", (Object)columns);
        return idObject;
    }

    public static boolean isEmbeddedInEntity(AssociationKey key, AssociationStorage storage) {
        return key != null && key.getAssociationKind() == AssociationKind.EMBEDDED || storage == AssociationStorage.IN_ENTITY;
    }

    public static Collection<DBObject> getAssociationFieldOrNull(AssociationKey key, DBObject entity) {
        String[] path = key.getCollectionRole().split("\\.");
        DBObject field = entity;
        for (String node : path) {
            field = field != null ? field.get(node) : null;
        }
        return (Collection)field;
    }

    public static void addEmptyAssociationField(AssociationKey key, DBObject entity) {
        String[] path = key.getCollectionRole().split("\\.");
        Object field = entity;
        int size = path.length;
        for (int index = 0; index < size; ++index) {
            DBObject parent = field;
            String node = path[index];
            if ((field = parent.get(node)) != null) continue;
            field = index == size - 1 ? Collections.EMPTY_LIST : new BasicDBObject();
            parent.put(node, field);
        }
    }

    public static Object getValueFromColumns(String column, String[] columns, Object[] values) {
        for (int index = 0; index < columns.length; ++index) {
            if (!columns[index].equals(column)) continue;
            return values[index];
        }
        return null;
    }
}

