/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.mongodb.impl;

import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.ogm.datastore.mongodb.AssociationStorage;
import org.hibernate.ogm.datastore.mongodb.impl.configuration.MongoDBConfiguration;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.dialect.mongodb.MongoDBDialect;
import org.hibernate.ogm.dialect.mongodb.query.parsing.MongoDBBasedQueryParserService;
import org.hibernate.ogm.logging.mongodb.impl.Log;
import org.hibernate.ogm.logging.mongodb.impl.LoggerFactory;
import org.hibernate.ogm.service.impl.QueryParserService;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;

public class MongoDBDatastoreProvider
implements DatastoreProvider,
Startable,
Stoppable,
Configurable {
    private static final Log log = LoggerFactory.getLogger();
    private boolean isCacheStarted;
    private MongoClient mongo;
    private DB mongoDb;
    private final MongoDBConfiguration config = new MongoDBConfiguration();

    public void configure(Map configurationValues) {
        this.config.initialize(configurationValues);
    }

    public AssociationStorage getAssociationStorage() {
        return this.config.getAssociationStorage();
    }

    public Class<? extends GridDialect> getDefaultDialect() {
        return MongoDBDialect.class;
    }

    public Class<? extends QueryParserService> getDefaultQueryParserServiceType() {
        return MongoDBBasedQueryParserService.class;
    }

    public void start() {
        if (!this.isCacheStarted) {
            try {
                ServerAddress serverAddress = new ServerAddress(this.config.getHost(), this.config.getPort());
                this.mongo = new MongoClient(serverAddress, this.config.buildOptions());
                this.isCacheStarted = true;
            }
            catch (UnknownHostException e) {
                throw log.mongoOnUnknownHost(this.config.getHost());
            }
            catch (RuntimeException e) {
                throw log.unableToInitializeMongoDB(e);
            }
            this.mongoDb = this.extractDatabase();
        }
    }

    public void stop() {
        log.disconnectingFromMongo();
        this.mongo.close();
    }

    public DB getDatabase() {
        return this.mongoDb;
    }

    private DB extractDatabase() {
        try {
            DB admin;
            boolean auth;
            if (this.config.getUsername() != null && !(auth = (admin = this.mongo.getDB("admin")).authenticate(this.config.getUsername(), this.config.getPassword().toCharArray()))) {
                throw log.authenticationFailed(this.config.getUsername());
            }
            if (!this.mongo.getDatabaseNames().contains(this.config.getDatabaseName())) {
                log.creatingDatabase(this.config.getDatabaseName());
            }
            return this.mongo.getDB(this.config.getDatabaseName());
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Exception e) {
            throw log.unableToConnectToDatastore(this.config.getHost(), this.config.getPort(), e);
        }
    }
}

