/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import java.util.Arrays;
import org.neo4j.collection.primitive.hopscotch.LongKeyTable;

public class LongKeyIntValueTable
extends LongKeyTable<int[]> {
    public static final int NULL = -1;
    private final int[] transport = new int[1];
    private int[] values;

    public LongKeyIntValueTable(int capacity) {
        super(capacity, new int[]{-1});
    }

    @Override
    protected void initializeTable() {
        super.initializeTable();
        this.values = new int[this.capacity];
    }

    @Override
    protected void clearTable() {
        super.clearTable();
        Arrays.fill(this.values, -1);
    }

    @Override
    public int[] value(int index) {
        int value = this.values[index];
        return value == -1 ? null : this.pack(value);
    }

    @Override
    public void put(int index, long key, int[] value) {
        this.values[index] = this.unpack(value);
        super.put(index, key, value);
    }

    @Override
    public int[] putValue(int index, int[] value) {
        int previous = this.values[index];
        this.values[index] = this.unpack(value);
        super.putValue(index, value);
        return this.pack(previous);
    }

    @Override
    public int[] remove(int index) {
        int[] result = this.pack(this.values[index]);
        this.values[index] = -1;
        super.remove(index);
        return result;
    }

    @Override
    public long move(int fromIndex, int toIndex) {
        this.values[toIndex] = this.values[fromIndex];
        this.values[fromIndex] = -1;
        return super.move(fromIndex, toIndex);
    }

    @Override
    protected LongKeyTable<int[]> newInstance(int newCapacity) {
        return new LongKeyIntValueTable(newCapacity);
    }

    private int unpack(int[] value) {
        return value[0];
    }

    private int[] pack(int value) {
        this.transport[0] = value;
        return this.transport;
    }
}

