/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.couchdb.impl;

import java.util.Map;
import org.hibernate.cfg.Configuration;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.ogm.datastore.couchdb.dialect.backend.impl.CouchDBDatastore;
import org.hibernate.ogm.datastore.couchdb.dialect.backend.json.designdocument.impl.TuplesDesignDocument;
import org.hibernate.ogm.datastore.couchdb.impl.CouchDBDatastoreProvider;
import org.hibernate.ogm.datastore.couchdb.logging.impl.Log;
import org.hibernate.ogm.datastore.couchdb.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.spi.BaseSchemaDefiner;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;

public class CouchDBSchemaSchemaDefiner
extends BaseSchemaDefiner {
    private static final Log logger = LoggerFactory.getLogger();

    public void validateMapping(SessionFactoryImplementor factory) {
        for (Map.Entry entityAndPersister : factory.getEntityPersisters().entrySet()) {
            if (this.hasRevisionColumn((OgmEntityPersister)entityAndPersister.getValue())) continue;
            logger.entityShouldHaveRevisionProperty((String)entityAndPersister.getKey());
        }
    }

    public void initializeSchema(Configuration configuration, SessionFactoryImplementor factory) {
        CouchDBDatastoreProvider datastoreProvider = (CouchDBDatastoreProvider)factory.getServiceRegistry().getService(DatastoreProvider.class);
        CouchDBDatastore dataStore = datastoreProvider.getDataStore();
        if (!dataStore.exists("tuples", true)) {
            dataStore.saveDocument(new TuplesDesignDocument());
        }
    }

    private boolean hasRevisionColumn(OgmEntityPersister persister) {
        for (int i = 0; i < persister.getPropertyNames().length; ++i) {
            for (String columnName : persister.getPropertyColumnNames(i)) {
                if (!columnName.equals("_rev")) continue;
                return true;
            }
        }
        return false;
    }
}

