/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.couchdb.dialect.model.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.datastore.document.association.spi.AssociationRow;
import org.hibernate.ogm.datastore.document.association.spi.StructureOptimizerAssociationRowFactory;

public class CouchDBAssociationRowFactory
extends StructureOptimizerAssociationRowFactory<Map<String, Object>> {
    public static final CouchDBAssociationRowFactory INSTANCE = new CouchDBAssociationRowFactory();

    private CouchDBAssociationRowFactory() {
        super(Map.class);
    }

    protected Map<String, Object> getSingleColumnRow(String columnName, Object value) {
        return Collections.singletonMap(columnName, value);
    }

    protected AssociationRow.AssociationRowAccessor<Map<String, Object>> getAssociationRowAccessor(String[] prefixedColumns, String prefix) {
        return CouchDBAssociationRowAccessor.INSTANCE;
    }

    private static class CouchDBAssociationRowAccessor
    implements AssociationRow.AssociationRowAccessor<Map<String, Object>> {
        private static final CouchDBAssociationRowAccessor INSTANCE = new CouchDBAssociationRowAccessor();
        private final String prefix;
        private final List<String> prefixedColumns;

        public CouchDBAssociationRowAccessor() {
            this(null, null);
        }

        public CouchDBAssociationRowAccessor(String[] prefixedColumns, String prefix) {
            this.prefix = prefix;
            this.prefixedColumns = prefix != null ? Arrays.asList(prefixedColumns) : new ArrayList<String>(0);
        }

        private String unprefix(String prefixedColumn) {
            return prefixedColumn.substring(this.prefix.length() + 1);
        }

        public Set<String> getColumnNames(Map<String, Object> row) {
            Set<String> columnNames = row.keySet();
            for (String prefixedColumn : this.prefixedColumns) {
                String unprefixedColumn = this.unprefix(prefixedColumn);
                if (!columnNames.contains(unprefixedColumn)) continue;
                columnNames.remove(unprefixedColumn);
                columnNames.add(prefixedColumn);
            }
            return columnNames;
        }

        public Object get(Map<String, Object> row, String column) {
            if (this.prefixedColumns.contains(column)) {
                column = this.unprefix(column);
            }
            return row.get(column);
        }
    }
}

