/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.couchdb.dialect.backend.impl;

import java.util.List;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.Response;
import org.hibernate.ogm.datastore.couchdb.dialect.backend.facade.impl.DatabaseClient;
import org.hibernate.ogm.datastore.couchdb.dialect.backend.facade.impl.ServerClient;
import org.hibernate.ogm.datastore.couchdb.dialect.backend.json.designdocument.impl.DesignDocument;
import org.hibernate.ogm.datastore.couchdb.dialect.backend.json.designdocument.impl.EntityTupleRows;
import org.hibernate.ogm.datastore.couchdb.dialect.backend.json.impl.AssociationDocument;
import org.hibernate.ogm.datastore.couchdb.dialect.backend.json.impl.Document;
import org.hibernate.ogm.datastore.couchdb.dialect.backend.json.impl.EntityDocument;
import org.hibernate.ogm.datastore.couchdb.dialect.backend.json.impl.GenericResponse;
import org.hibernate.ogm.datastore.couchdb.dialect.backend.json.impl.SequenceDocument;
import org.hibernate.ogm.datastore.couchdb.logging.impl.Log;
import org.hibernate.ogm.datastore.couchdb.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.couchdb.util.impl.DatabaseIdentifier;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.IdSourceKey;
import org.hibernate.ogm.model.spi.Tuple;
import org.jboss.resteasy.client.exception.ResteasyClientException;
import org.jboss.resteasy.client.jaxrs.BasicAuthentication;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class CouchDBDatastore {
    private static final int CONNECTION_POOL_SIZE = 10;
    private static final Log logger = LoggerFactory.getLogger();
    private final DatabaseIdentifier database;
    private final ResteasyClient client;
    private final DatabaseClient databaseClient;

    private CouchDBDatastore(DatabaseIdentifier database) {
        logger.connectingToCouchDB(database.getDatabaseName() + "@" + database.getServerUri().toString());
        this.client = CouchDBDatastore.createRestClient(database);
        this.databaseClient = (DatabaseClient)this.client.target(database.getDatabaseUri()).proxy(DatabaseClient.class);
        this.database = database;
    }

    public static CouchDBDatastore newInstance(DatabaseIdentifier database, boolean createDatabase) {
        RegisterBuiltin.register((ResteasyProviderFactory)ResteasyProviderFactory.getInstance());
        CouchDBDatastore couchDBDatastore = new CouchDBDatastore(database);
        couchDBDatastore.initialize(createDatabase);
        return couchDBDatastore;
    }

    private void initialize(boolean createDatabase) {
        ServerClient serverClient = (ServerClient)this.client.target(this.database.getServerUri()).proxy(ServerClient.class);
        if (createDatabase) {
            this.createDatabase(serverClient);
        } else if (!this.databaseExists(serverClient, this.database.getDatabaseName())) {
            throw logger.databaseDoesNotExistException(this.database.getDatabaseName());
        }
    }

    public Document saveDocument(Document document) {
        return this.doSaveDocument(document, false);
    }

    public Document saveDocument(DesignDocument design) {
        return this.doSaveDocument(design, true);
    }

    private Document doSaveDocument(Document document, boolean isDesignDocument) {
        Response response = null;
        try {
            response = isDesignDocument ? this.databaseClient.saveDesign((DesignDocument)document, document.getId()) : this.databaseClient.saveDocument(document, document.getId());
            if (response.getStatus() != Response.Status.CREATED.getStatusCode()) {
                if (response.getStatus() == Response.Status.CONFLICT.getStatusCode()) {
                    throw logger.getDocumentHasBeenConcurrentlyModifiedException(document.getId());
                }
                GenericResponse entity = (GenericResponse)response.readEntity(GenericResponse.class);
                throw logger.errorCreatingDocument(response.getStatus(), entity.getError(), entity.getReason());
            }
            Object entity = (GenericResponse)response.readEntity(GenericResponse.class);
            this.updateDocumentRevision(document, ((GenericResponse)entity).getRev());
            entity = document;
            return entity;
        }
        catch (ResteasyClientException e) {
            throw logger.couchDBConnectionProblem((Exception)((Object)e));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    public EntityDocument getEntity(String id) {
        Response response = null;
        try {
            response = this.databaseClient.getEntityById(id);
            if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                EntityDocument entityDocument = null;
                return entityDocument;
            }
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                EntityDocument entityDocument = (EntityDocument)response.readEntity(EntityDocument.class);
                return entityDocument;
            }
            try {
                GenericResponse responseEntity = (GenericResponse)response.readEntity(GenericResponse.class);
                throw logger.errorRetrievingEntity(id, response.getStatus(), responseEntity.getError(), responseEntity.getReason());
            }
            catch (ResteasyClientException e) {
                throw logger.couchDBConnectionProblem((Exception)((Object)e));
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    public String getCurrentRevision(String documentId, boolean isDesignDocument) {
        Response response = null;
        try {
            Response response2 = response = isDesignDocument ? this.databaseClient.getCurrentRevisionOfDesignDocument(documentId) : this.databaseClient.getCurrentRevision(documentId);
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                String string = response.getEntityTag().getValue();
                return string;
            }
            if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                String string = null;
                return string;
            }
            try {
                GenericResponse responseEntity = response.hasEntity() ? (GenericResponse)response.readEntity(GenericResponse.class) : null;
                throw logger.errorRetrievingCurrentRevision(documentId, response.getStatus(), responseEntity != null ? responseEntity.getError() : null, responseEntity != null ? responseEntity.getReason() : null);
            }
            catch (ResteasyClientException e) {
                throw logger.couchDBConnectionProblem((Exception)((Object)e));
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    public boolean exists(String documentId, boolean isDesignDocument) {
        return this.getCurrentRevision(documentId, isDesignDocument) != null;
    }

    public AssociationDocument getAssociation(String id) {
        Response response = null;
        try {
            response = this.databaseClient.getAssociationById(id);
            if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                AssociationDocument associationDocument = null;
                return associationDocument;
            }
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                AssociationDocument associationDocument = (AssociationDocument)response.readEntity(AssociationDocument.class);
                return associationDocument;
            }
            try {
                GenericResponse responseEntity = (GenericResponse)response.readEntity(GenericResponse.class);
                throw logger.errorRetrievingAssociation(id, response.getStatus(), responseEntity.getError(), responseEntity.getReason());
            }
            catch (ResteasyClientException e) {
                throw logger.couchDBConnectionProblem((Exception)((Object)e));
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    public List<Tuple> getTuples(EntityKeyMetadata entityKeyMetadata) {
        String tableName = this.getTableName(entityKeyMetadata);
        return this.getTuplesByTableName(tableName);
    }

    public long nextValue(IdSourceKey key, int increment, int initialValue) {
        long value;
        try {
            SequenceDocument sequence = this.getSequence(key, initialValue);
            value = sequence.getValue();
            this.incrementValueAndSave(increment, sequence);
        }
        catch (ResteasyClientException crf) {
            throw logger.errorCalculatingNextValue((Exception)((Object)crf));
        }
        return value;
    }

    public void deleteDocument(String id, String revision) {
        Response response = null;
        try {
            response = this.databaseClient.deleteDocument(id, revision);
            if (response.getStatus() == Response.Status.CONFLICT.getStatusCode()) {
                throw logger.getDocumentHasBeenConcurrentlyModifiedException(id);
            }
            if (response.getStatus() != Response.Status.OK.getStatusCode() && response.getStatus() != Response.Status.NOT_FOUND.getStatusCode()) {
                throw logger.errorDeletingDocument(response.getStatus(), null, null);
            }
        }
        catch (ResteasyClientException e) {
            throw logger.couchDBConnectionProblem((Exception)((Object)e));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    public void dropDatabase() {
        Response response = null;
        try {
            response = this.databaseClient.dropDatabase();
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                GenericResponse responseEntity = (GenericResponse)response.readEntity(GenericResponse.class);
                throw logger.errorDroppingDatabase(response.getStatus(), responseEntity.getError(), responseEntity.getReason());
            }
        }
        catch (ResteasyClientException e) {
            throw logger.couchDBConnectionProblem((Exception)((Object)e));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    public void shutDown() {
        if (this.client != null) {
            this.client.close();
        }
    }

    public DatabaseIdentifier getDatabaseIdentifier() {
        return this.database;
    }

    private void createDatabase(ServerClient serverClient) {
        Response response = null;
        try {
            if (!this.databaseExists(serverClient, this.database.getDatabaseName()) && (response = serverClient.createDatabase(this.database.getDatabaseName())).getStatus() != Response.Status.CREATED.getStatusCode()) {
                GenericResponse entity = (GenericResponse)response.readEntity(GenericResponse.class);
                throw logger.errorCreatingDatabase(this.database.getDatabaseName(), response.getStatus(), entity.getError(), entity.getReason());
            }
        }
        catch (ResteasyClientException e) {
            throw logger.couchDBConnectionProblem((Exception)((Object)e));
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    private boolean databaseExists(ServerClient serverClient, String databaseName) {
        Response response = null;
        try {
            response = serverClient.getAllDatabaseNames();
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                List entity = (List)response.readEntity(List.class);
                if (entity.contains(databaseName)) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            try {
                GenericResponse responseEntity = (GenericResponse)response.readEntity(GenericResponse.class);
                throw logger.unableToRetrieveTheListOfDatabase(response.getStatus(), responseEntity.getError(), responseEntity.getReason());
            }
            catch (ProcessingException e) {
                throw logger.couchDBConnectionProblem((Exception)((Object)e));
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    private List<Tuple> getTuplesByTableName(String tableName) {
        Response response = null;
        try {
            response = this.databaseClient.getEntityTuplesByTableName("\"" + tableName + "\"");
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                List<Tuple> list = ((EntityTupleRows)response.readEntity(EntityTupleRows.class)).getTuples();
                return list;
            }
            try {
                GenericResponse responseEntity = (GenericResponse)response.readEntity(GenericResponse.class);
                throw logger.unableToRetrieveTheTupleByEntityKeyMetadata(tableName, response.getStatus(), responseEntity.getError(), responseEntity.getReason());
            }
            catch (ResteasyClientException e) {
                throw logger.couchDBConnectionProblem((Exception)((Object)e));
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }

    private void incrementValueAndSave(int increment, SequenceDocument identifier) {
        identifier.increase(increment);
        this.saveDocument(identifier);
    }

    private String getTableName(EntityKeyMetadata entityKeyMetadata) {
        return entityKeyMetadata.getTable();
    }

    private static ResteasyClient createRestClient(DatabaseIdentifier database) {
        ResteasyClientBuilder clientBuilder = new ResteasyClientBuilder();
        if (database.getUserName() != null) {
            clientBuilder.register((Object)new BasicAuthentication(database.getUserName(), database.getPassword()));
        }
        return clientBuilder.connectionPoolSize(10).build();
    }

    private void updateDocumentRevision(Document document, String revision) {
        document.setRevision(revision);
    }

    private String createId(IdSourceKey key) {
        int i;
        StringBuilder builder = new StringBuilder(key.getTable());
        builder.append(":");
        for (i = 0; i < key.getColumnNames().length; ++i) {
            builder.append(key.getColumnNames()[i]);
        }
        builder.append(":");
        for (i = 0; i < key.getColumnValues().length; ++i) {
            builder.append(key.getColumnValues()[i]);
        }
        return builder.toString();
    }

    private SequenceDocument getSequence(IdSourceKey key, int initialValue) {
        Response response = null;
        try {
            String id = this.createId(key);
            response = this.databaseClient.getKeyValueById(id);
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                SequenceDocument sequenceDocument = (SequenceDocument)response.readEntity(SequenceDocument.class);
                return sequenceDocument;
            }
            if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                SequenceDocument identifier = new SequenceDocument(key.getMetadata().getValueColumnName(), initialValue);
                identifier.setId(id);
                SequenceDocument sequenceDocument = identifier;
                return sequenceDocument;
            }
            try {
                GenericResponse responseEntity = (GenericResponse)response.readEntity(GenericResponse.class);
                throw logger.errorRetrievingKeyValue(response.getStatus(), responseEntity.getError(), responseEntity.getReason());
            }
            catch (ResteasyClientException e) {
                throw logger.couchDBConnectionProblem((Exception)((Object)e));
            }
        }
        finally {
            if (response != null) {
                response.close();
            }
        }
    }
}

