/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.IOException;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogByteSizeMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.neo4j.index.impl.lucene.LuceneDataSource;
import org.neo4j.index.impl.lucene.MultipleBackupDeletionPolicy;
import org.neo4j.kernel.api.impl.index.LuceneIndexWriterFactory;

public class IndexWriterFactories {
    public static LuceneIndexWriterFactory standard() {
        return new LuceneIndexWriterFactory(){

            @Override
            public IndexWriter create(Directory directory) throws IOException {
                IndexWriterConfig writerConfig = new IndexWriterConfig(Version.LUCENE_36, LuceneDataSource.KEYWORD_ANALYZER);
                writerConfig.setMaxBufferedDocs(100000);
                writerConfig.setIndexDeletionPolicy((IndexDeletionPolicy)new MultipleBackupDeletionPolicy());
                writerConfig.setTermIndexInterval(14);
                LogByteSizeMergePolicy mergePolicy = new LogByteSizeMergePolicy();
                mergePolicy.setUseCompoundFile(true);
                mergePolicy.setNoCFSRatio(1.0);
                mergePolicy.setMinMergeMB(0.1);
                mergePolicy.setMergeFactor(2);
                writerConfig.setMergePolicy((MergePolicy)mergePolicy);
                return new IndexWriter(directory, writerConfig);
            }
        };
    }
}

