/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.lucene;

import java.io.File;
import java.io.IOException;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.IndexWriterFactories;
import org.neo4j.kernel.api.impl.index.LuceneLabelScanStore;
import org.neo4j.kernel.api.impl.index.NodeRangeDocumentLabelScanStorageStrategy;
import org.neo4j.kernel.api.labelscan.LabelScanStore;
import org.neo4j.kernel.impl.api.scan.LabelScanStoreProvider;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreProvider;
import org.neo4j.kernel.impl.nioneo.xa.SimpleNeoStoreProvider;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.logging.SingleLoggingService;

public class LuceneLabelScanStoreBuilder {
    private final String storeDir;
    private final NeoStoreProvider neoStoreProvider;
    private final FileSystemAbstraction fileSystem;
    private final SingleLoggingService logger;
    private LuceneLabelScanStore labelScanStore = null;

    public LuceneLabelScanStoreBuilder(String storeDir, NeoStore neoStore, FileSystemAbstraction fileSystem, StringLogger logger) {
        this.storeDir = storeDir;
        this.neoStoreProvider = new SimpleNeoStoreProvider(neoStore);
        this.fileSystem = fileSystem;
        this.logger = new SingleLoggingService(logger);
    }

    public LabelScanStore build() {
        if (null == this.labelScanStore) {
            this.labelScanStore = new LuceneLabelScanStore(new NodeRangeDocumentLabelScanStorageStrategy(), DirectoryFactory.PERSISTENT, new File(new File(new File(this.storeDir, "schema"), "label"), "lucene"), this.fileSystem, IndexWriterFactories.standard(), LabelScanStoreProvider.fullStoreLabelUpdateStream((NeoStoreProvider)this.neoStoreProvider), LuceneLabelScanStore.loggerMonitor((Logging)this.logger));
            try {
                this.labelScanStore.init();
                this.labelScanStore.start();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.labelScanStore;
    }
}

