/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.staging;

import org.neo4j.unsafe.impl.batchimport.staging.ExecutionMonitor;
import org.neo4j.unsafe.impl.batchimport.staging.StageExecution;
import org.neo4j.unsafe.impl.batchimport.stats.Keys;
import org.neo4j.unsafe.impl.batchimport.stats.StepStats;

public abstract class PollingExecutionMonitor
implements ExecutionMonitor {
    private final long interval;

    public PollingExecutionMonitor(long interval) {
        this.interval = interval;
    }

    @Override
    public void monitor(StageExecution ... executions) {
        long startTime = System.currentTimeMillis();
        this.start(executions);
        while (this.anyStillExecuting(executions)) {
            this.poll(executions);
            this.finishAwareSleep(executions);
        }
        this.end(executions, System.currentTimeMillis() - startTime);
    }

    private boolean anyStillExecuting(StageExecution[] executions) {
        for (StageExecution execution : executions) {
            if (!execution.stillExecuting()) continue;
            return true;
        }
        return false;
    }

    protected void end(StageExecution[] executions, long totalTimeMillis) {
    }

    protected void start(StageExecution[] executions) {
    }

    protected abstract void poll(StageExecution[] var1);

    private void finishAwareSleep(StageExecution[] executions) {
        long endTime = System.currentTimeMillis() + this.interval;
        while (System.currentTimeMillis() < endTime && this.anyStillExecuting(executions)) {
            try {
                Thread.sleep(Math.min(10L, Math.max(0L, endTime - System.currentTimeMillis())));
            }
            catch (InterruptedException e) {
                for (StageExecution execution : executions) {
                    execution.panic(e);
                }
            }
        }
    }

    protected int figureOutBottleNeck(StageExecution execution) {
        int leaderIndex = -1;
        StepStats leader = null;
        int index = 0;
        for (StepStats stat : execution.stats()) {
            if (leader == null || stat.stat(Keys.downstream_idle_time).asLong() + stat.stat(Keys.upstream_idle_time).asLong() < leader.stat(Keys.downstream_idle_time).asLong() + leader.stat(Keys.upstream_idle_time).asLong()) {
                leader = stat;
                leaderIndex = index;
            }
            ++index;
        }
        return leaderIndex;
    }
}

