/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util.statistics;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.helpers.collection.MapUtil;

public class LabelledDistribution<T>
implements Serializable {
    private static final long serialVersionUID = -6076855164000786095L;
    private final Map<T, Long> rawData = new HashMap<T, Long>();
    private final double equalityTolerance;
    private long total = 0L;
    private Map<T, Double> distribution = new HashMap<T, Double>();

    public LabelledDistribution(double equalityTolerance) {
        this.equalityTolerance = equalityTolerance;
    }

    public double get(T label) {
        Double value = this.distribution.get(label);
        return value == null ? 0.0 : value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LabelledDistribution<T> record(Iterable<T> labels, int ticks) {
        Map<T, Long> map = this.rawData;
        synchronized (map) {
            Iterator<T> i$ = labels.iterator();
            while (i$.hasNext()) {
                T label;
                Long current = this.rawData.get(label = i$.next());
                this.rawData.put(label, (current == null ? 0L : current) + (long)ticks);
            }
            this.total += (long)ticks;
            return this;
        }
    }

    public LabelledDistribution<T> record(Iterable<T> labels) {
        return this.record(labels, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LabelledDistribution<T> recalculate() {
        Map<T, Long> map = this.rawData;
        synchronized (map) {
            HashMap<T, Double> newDistribution = new HashMap<T, Double>();
            for (Map.Entry<T, Long> entry : this.rawData.entrySet()) {
                newDistribution.put(entry.getKey(), entry.getValue().doubleValue() / (double)this.total);
            }
            this.distribution = newDistribution;
            return this;
        }
    }

    public String toString() {
        return this.distribution.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        LabelledDistribution other = (LabelledDistribution)obj;
        return this.equalityTolerance == other.equalityTolerance && MapUtil.approximatelyEqual(this.distribution, other.distribution, this.equalityTolerance);
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.equalityTolerance);
        return (int)(temp ^ temp >>> 32);
    }
}

