/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.helpers.collection.IteratorUtil;

class CopyOnWriteAfterIteratorHashSet<E>
implements Set<E> {
    private transient HashMap<E, Object> map;
    private boolean readOnly = false;
    private static final Object PRESENT = new Object();

    CopyOnWriteAfterIteratorHashSet() {
    }

    @Override
    public Iterator<E> iterator() {
        if (this.map == null || this.map.isEmpty()) {
            return IteratorUtil.emptyIterator();
        }
        this.readOnly = true;
        return this.map.keySet().iterator();
    }

    public String toString() {
        return this.map == null ? "[]" : this.map.keySet().toString();
    }

    @Override
    public Object[] toArray() {
        return this.map == null ? new Object[]{} : this.map.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map == null ? a : this.map.keySet().toArray(a);
    }

    @Override
    public int size() {
        return this.map == null ? 0 : this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map == null || this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map != null && this.map.containsKey(o);
    }

    @Override
    public boolean add(E e) {
        if (this.map == null) {
            this.map = new HashMap();
        }
        if (this.readOnly) {
            if (this.map.containsKey(e)) {
                return false;
            }
            this.map = new HashMap<E, Object>(this.map);
            this.readOnly = false;
        }
        return this.map.put(e, PRESENT) == null;
    }

    @Override
    public boolean remove(Object o) {
        if (this.map == null) {
            return false;
        }
        if (this.readOnly) {
            if (!this.map.containsKey(o)) {
                return false;
            }
            this.map = new HashMap<E, Object>(this.map);
            this.readOnly = false;
        }
        return this.map.remove(o) == PRESENT;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.map == null ? c.isEmpty() : this.map.keySet().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean modified = false;
        for (E e : c) {
            if (!this.add(e)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.readOnly = false;
        this.map = null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.conditionalRemove(c, true);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.conditionalRemove(c, false);
    }

    private boolean conditionalRemove(Collection<?> c, boolean remove) {
        HashMap<E, Object> target;
        if (this.map == null || this.map.isEmpty()) {
            return false;
        }
        boolean modified = false;
        Iterator<E> it = this.map.keySet().iterator();
        HashMap<E, Object> hashMap = target = this.readOnly ? null : this.map;
        while (it.hasNext()) {
            E item = it.next();
            if (c.contains(item) != remove) continue;
            if (this.readOnly) {
                if (target == null) {
                    target = new HashMap<E, Object>(this.map);
                }
                target.remove(item);
            } else {
                it.remove();
            }
            modified = true;
        }
        if (target != null && target != this.map) {
            this.map = target;
            this.readOnly = false;
        }
        return modified;
    }
}

