/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa.command;

import java.io.IOException;
import java.util.Collection;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.LabelTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyBlock;
import org.neo4j.kernel.impl.nioneo.store.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyRecord;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.RelationshipGroupRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandWriter;
import org.neo4j.kernel.impl.nioneo.xa.command.Command;
import org.neo4j.kernel.impl.nioneo.xa.command.NeoCommandVisitor;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;

public class PhysicalLogNeoXaCommandWriter
implements XaCommandWriter {
    @Override
    public void write(XaCommand command, LogBuffer buffer) throws IOException {
        Command neoCommand = (Command)command;
        neoCommand.accept(new PhysicalLogNeoCommandWriter(buffer));
    }

    public class PhysicalLogNeoCommandWriter
    implements NeoCommandVisitor {
        private final LogBuffer buffer;

        public PhysicalLogNeoCommandWriter(LogBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public boolean visitNodeCommand(Command.NodeCommand command) throws IOException {
            NodeRecord before = command.getBefore();
            NodeRecord after = command.getAfter();
            this.buffer.put((byte)1);
            this.buffer.putLong(after.getId());
            this.writeNodeRecord(before);
            this.writeNodeRecord(after);
            return true;
        }

        @Override
        public boolean visitRelationshipCommand(Command.RelationshipCommand command) throws IOException {
            RelationshipRecord record = command.getRecord();
            byte inUse = record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
            this.buffer.put((byte)3);
            this.buffer.putLong(record.getId());
            this.buffer.put(inUse);
            if (record.inUse()) {
                this.buffer.putLong(record.getFirstNode()).putLong(record.getSecondNode()).putInt(record.getType()).putLong(record.getFirstPrevRel()).putLong(record.getFirstNextRel()).putLong(record.getSecondPrevRel()).putLong(record.getSecondNextRel()).putLong(record.getNextProp()).put((byte)((record.isFirstInFirstChain() ? 1 : 0) | (record.isFirstInSecondChain() ? 2 : 0)));
            }
            return true;
        }

        private boolean writeNodeRecord(NodeRecord record) throws IOException {
            byte inUse = record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
            this.buffer.put(inUse);
            if (record.inUse()) {
                this.buffer.put(record.isDense() ? (byte)1 : 0);
                this.buffer.putLong(record.getNextRel()).putLong(record.getNextProp());
                this.buffer.putLong(record.getLabelField());
                this.writeDynamicRecords(record.getDynamicLabelRecords());
            }
            return true;
        }

        @Override
        public boolean visitPropertyCommand(Command.PropertyCommand command) throws IOException {
            this.buffer.put((byte)2);
            this.buffer.putLong(command.getKey());
            this.writePropertyRecord(command.getBefore());
            this.writePropertyRecord(command.getAfter());
            return true;
        }

        @Override
        public boolean visitRelationshipGroupCommand(Command.RelationshipGroupCommand command) throws IOException {
            RelationshipGroupRecord record = command.getRecord();
            this.buffer.put((byte)9);
            this.buffer.putLong(record.getId());
            this.buffer.put((byte)(record.inUse() ? Record.IN_USE.intValue() : Record.NOT_IN_USE.intValue()));
            this.buffer.putShort((short)record.getType());
            this.buffer.putLong(record.getNext());
            this.buffer.putLong(record.getFirstOut());
            this.buffer.putLong(record.getFirstIn());
            this.buffer.putLong(record.getFirstLoop());
            this.buffer.putLong(record.getOwningNode());
            return true;
        }

        @Override
        public boolean visitRelationshipTypeTokenCommand(Command.RelationshipTypeTokenCommand command) throws IOException {
            RelationshipTypeTokenRecord record = command.getRecord();
            byte inUse = record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
            this.buffer.put((byte)4);
            this.buffer.putInt(record.getId()).put(inUse).putInt(record.getNameId());
            this.writeDynamicRecords(record.getNameRecords());
            return true;
        }

        @Override
        public boolean visitLabelTokenCommand(Command.LabelTokenCommand command) throws IOException {
            LabelTokenRecord record = command.getRecord();
            byte inUse = record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
            this.buffer.put((byte)8);
            this.buffer.putInt(record.getId()).put(inUse).putInt(record.getNameId());
            this.writeDynamicRecords(record.getNameRecords());
            return true;
        }

        @Override
        public boolean visitPropertyKeyTokenCommand(Command.PropertyKeyTokenCommand command) throws IOException {
            PropertyKeyTokenRecord record = command.getRecord();
            byte inUse = record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
            this.buffer.put((byte)5);
            this.buffer.putInt(record.getId());
            this.buffer.put(inUse);
            this.buffer.putInt(record.getPropertyCount()).putInt(record.getNameId());
            if (record.isLight()) {
                this.buffer.putInt(0);
            } else {
                this.writeDynamicRecords(record.getNameRecords());
            }
            return true;
        }

        @Override
        public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) throws IOException {
            Collection<DynamicRecord> recordsAfter = command.getRecordsAfter();
            this.buffer.put((byte)7);
            this.writeDynamicRecords(command.getRecordsBefore());
            this.writeDynamicRecords(recordsAfter);
            this.buffer.put(IteratorUtil.first(recordsAfter).isCreated() ? (byte)1 : 0);
            this.buffer.putLong(command.getTxId());
            return true;
        }

        @Override
        public boolean visitNeoStoreCommand(Command.NeoStoreCommand command) throws IOException {
            this.buffer.put((byte)6).putLong(command.getRecord().getNextProp());
            return true;
        }

        void writeDynamicRecords(Collection<DynamicRecord> records) throws IOException {
            this.buffer.putInt(records.size());
            for (DynamicRecord record : records) {
                this.writeDynamicRecord(record);
            }
        }

        void writeDynamicRecord(DynamicRecord record) throws IOException {
            if (record.inUse()) {
                byte inUse = Record.IN_USE.byteValue();
                if (record.isStartRecord()) {
                    inUse = (byte)(inUse | Record.FIRST_IN_CHAIN.byteValue());
                }
                this.buffer.putLong(record.getId()).putInt(record.getType()).put(inUse).putInt(record.getLength()).putLong(record.getNextBlock());
                byte[] data = record.getData();
                assert (data != null);
                this.buffer.put(data);
            } else {
                byte inUse = Record.NOT_IN_USE.byteValue();
                this.buffer.putLong(record.getId()).putInt(record.getType()).put(inUse);
            }
        }

        private void writePropertyBlock(PropertyBlock block) throws IOException {
            long[] propBlockValues;
            byte blockSize = (byte)block.getSize();
            assert (blockSize > 0) : blockSize + " is not a valid block size value";
            this.buffer.put(blockSize);
            for (long propBlockValue : propBlockValues = block.getValueBlocks()) {
                this.buffer.putLong(propBlockValue);
            }
            if (block.isLight()) {
                this.buffer.putInt(0);
            } else {
                this.writeDynamicRecords(block.getValueRecords());
            }
        }

        private void writePropertyRecord(PropertyRecord record) throws IOException {
            byte inUse;
            byte by = inUse = record.inUse() ? Record.IN_USE.byteValue() : Record.NOT_IN_USE.byteValue();
            if (record.getRelId() != -1L) {
                inUse = (byte)(inUse + Record.REL_PROPERTY.byteValue());
            }
            this.buffer.put(inUse);
            this.buffer.putLong(record.getNextProp()).putLong(record.getPrevProp());
            long nodeId = record.getNodeId();
            long relId = record.getRelId();
            if (nodeId != -1L) {
                this.buffer.putLong(nodeId);
            } else if (relId != -1L) {
                this.buffer.putLong(relId);
            } else {
                this.buffer.putLong(-1L);
            }
            this.buffer.put((byte)record.getPropertyBlocks().size());
            for (int i = 0; i < record.getPropertyBlocks().size(); ++i) {
                PropertyBlock block = record.getPropertyBlocks().get(i);
                assert (block.getSize() > 0) : record + " seems kinda broken";
                this.writePropertyBlock(block);
            }
            this.writeDynamicRecords(record.getDeletedRecords());
        }
    }
}

