/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.xa;

import java.util.Collection;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.nioneo.store.DynamicRecord;
import org.neo4j.kernel.impl.nioneo.store.PropertyStore;
import org.neo4j.kernel.impl.nioneo.store.TokenRecord;
import org.neo4j.kernel.impl.nioneo.store.TokenStore;
import org.neo4j.kernel.impl.nioneo.xa.RecordAccess;

public class TokenCreator<T extends TokenRecord> {
    private final TokenStore<T> store;

    public TokenCreator(TokenStore<T> store) {
        this.store = store;
    }

    public void createToken(String name, int id, RecordAccess<Integer, T, Void> recordAccess) {
        TokenRecord record = (TokenRecord)recordAccess.create(id, null).forChangingData();
        record.setInUse(true);
        record.setCreated();
        Collection<DynamicRecord> nameRecords = this.store.allocateNameRecords(PropertyStore.encodeString(name));
        record.setNameId((int)IteratorUtil.first(nameRecords).getId());
        record.addNameRecords(nameRecords);
    }
}

