/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.neo4j.kernel.impl.nioneo.store.AbstractSchemaRule;
import org.neo4j.kernel.impl.nioneo.store.SchemaRule;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;

public class UniquenessConstraintRule
extends AbstractSchemaRule {
    private final int[] propertyKeyIds;
    private final long ownedIndexRule;

    public static UniquenessConstraintRule uniquenessConstraintRule(long id, int labelId, int propertyKeyId, long ownedIndexRule) {
        return new UniquenessConstraintRule(id, labelId, new int[]{propertyKeyId}, ownedIndexRule);
    }

    public static UniquenessConstraintRule readUniquenessConstraintRule(long id, int labelId, ByteBuffer buffer) {
        return new UniquenessConstraintRule(id, labelId, UniquenessConstraintRule.readPropertyKeys(buffer), UniquenessConstraintRule.readOwnedIndexRule(buffer));
    }

    private UniquenessConstraintRule(long id, int labelId, int[] propertyKeyIds, long ownedIndexRule) {
        super(id, labelId, SchemaRule.Kind.UNIQUENESS_CONSTRAINT);
        this.ownedIndexRule = ownedIndexRule;
        assert (propertyKeyIds.length == 1);
        this.propertyKeyIds = propertyKeyIds;
    }

    @Override
    public int hashCode() {
        return super.hashCode() | Arrays.hashCode(this.propertyKeyIds);
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && Arrays.equals(this.propertyKeyIds, ((UniquenessConstraintRule)obj).propertyKeyIds);
    }

    @Override
    protected String innerToString() {
        return ", propertyKeys=" + Arrays.toString(this.propertyKeyIds) + ", ownedIndex=" + this.ownedIndexRule;
    }

    @Override
    public int length() {
        return super.length() + 1 + 8 * this.propertyKeyIds.length + 8;
    }

    @Override
    public void serialize(ByteBuffer target) {
        super.serialize(target);
        target.put((byte)this.propertyKeyIds.length);
        for (int propertyKeyId : this.propertyKeyIds) {
            target.putLong(propertyKeyId);
        }
        target.putLong(this.ownedIndexRule);
    }

    private static int[] readPropertyKeys(ByteBuffer buffer) {
        int[] keys = new int[buffer.get()];
        for (int i = 0; i < keys.length; ++i) {
            keys[i] = IoPrimitiveUtils.safeCastLongToInt(buffer.getLong());
        }
        return keys;
    }

    private static long readOwnedIndexRule(ByteBuffer buffer) {
        return buffer.getLong();
    }

    public boolean containsPropertyKeyId(int propertyKeyId) {
        for (int keyId : this.propertyKeyIds) {
            if (keyId != propertyKeyId) continue;
            return true;
        }
        return false;
    }

    public int getPropertyKey() {
        return this.propertyKeyIds[0];
    }

    public long getOwnedIndex() {
        return this.ownedIndexRule;
    }
}

