/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.nioneo.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.neo4j.helpers.UTF8;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.CommonAbstractStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.Record;
import org.neo4j.kernel.impl.nioneo.store.StoreVersionMismatchHandler;
import org.neo4j.kernel.impl.nioneo.store.WindowPoolStats;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPoolFactory;
import org.neo4j.kernel.impl.util.StringLogger;

public abstract class AbstractStore
extends CommonAbstractStore {
    private final Config conf;

    @Override
    public abstract int getRecordSize();

    public AbstractStore(File fileName, Config conf, IdType idType, IdGeneratorFactory idGeneratorFactory, WindowPoolFactory windowPoolFactory, FileSystemAbstraction fileSystemAbstraction, StringLogger stringLogger, StoreVersionMismatchHandler versionMismatchHandler) {
        super(fileName, conf, idType, idGeneratorFactory, windowPoolFactory, fileSystemAbstraction, stringLogger, versionMismatchHandler);
        this.conf = conf;
    }

    @Override
    protected int getEffectiveRecordSize() {
        return this.getRecordSize();
    }

    @Override
    protected void readAndVerifyBlockSize() throws IOException {
    }

    @Override
    protected void verifyFileSizeAndTruncate() throws IOException {
        int expectedVersionLength = UTF8.encode(AbstractStore.buildTypeDescriptorAndVersion(this.getTypeDescriptor())).length;
        long fileSize = this.getFileChannel().size();
        if (this.getRecordSize() != 0 && (fileSize - (long)expectedVersionLength) % (long)this.getRecordSize() != 0L && !this.isReadOnly()) {
            this.setStoreNotOk(new IllegalStateException("Misaligned file size " + fileSize + " for " + this + ", expected version length:" + expectedVersionLength));
        }
        if (this.getStoreOk() && !this.isReadOnly()) {
            this.getFileChannel().truncate(fileSize - (long)expectedVersionLength);
        }
    }

    @Override
    protected boolean isRecordInUse(ByteBuffer buffer) {
        byte inUse = buffer.get();
        return (inUse & 1) == Record.IN_USE.byteValue();
    }

    public abstract List<WindowPoolStats> getAllWindowPoolStats();

    public void logAllWindowPoolStats(StringLogger.LineLogger logger) {
        logger.logLine(this.getWindowPoolStats().toString());
    }

    public static abstract class Configuration
    extends CommonAbstractStore.Configuration {
    }
}

