/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.cache;

import org.neo4j.kernel.impl.util.StringLogger;

public class MeasureDoNothing
extends Thread {
    private volatile boolean measure = true;
    private final long TIME_TO_WAIT;
    private final long NOTIFICATION_THRESHOLD;
    private final StringLogger logger;

    public MeasureDoNothing(String threadName, StringLogger logger, long timeToWait, long pauseNotificationThreshold) {
        super(threadName);
        if (logger == null) {
            throw new IllegalArgumentException("Null message log");
        }
        this.logger = logger;
        this.TIME_TO_WAIT = timeToWait;
        this.NOTIFICATION_THRESHOLD = pauseNotificationThreshold + timeToWait;
        this.setDaemon(true);
    }

    @Override
    public synchronized void run() {
        this.logger.debug("GC Monitor started. ");
        while (this.measure) {
            long time;
            long start = System.nanoTime();
            try {
                this.wait(this.TIME_TO_WAIT);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            if ((time = (System.nanoTime() - start) / 1000000L) <= this.NOTIFICATION_THRESHOLD) continue;
            long blockTime = time - this.TIME_TO_WAIT;
            this.logger.warn(String.format("GC Monitor: Application threads blocked for %dms.", blockTime));
        }
        this.logger.debug("GC Monitor stopped. ");
    }

    public synchronized void stopMeasuring() {
        this.measure = false;
        this.interrupt();
    }
}

