/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.statistics;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.neo4j.graphdb.Direction;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.heuristics.StatisticsData;
import org.neo4j.kernel.impl.api.statistics.StatisticsCollectedData;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.util.statistics.RollingAverage;

public class StatisticsCollector
implements Runnable {
    private final StatisticsCollectedData collectedData;
    private final StoreReadLayer store;
    private final Random random = new Random();

    public StatisticsCollector(StoreReadLayer store, StatisticsCollectedData collectedData) {
        this.collectedData = collectedData;
        this.store = store;
    }

    private void addNodeObservation(List<Integer> nodeLabels, List<Integer> nodeRelTypes, Map<Integer, Integer> nodeIncoming, Map<Integer, Integer> nodeOutgoing) {
        this.collectedData.recordLabels(nodeLabels);
        this.collectedData.recordRelationshipTypes(nodeRelTypes);
        this.recordNodeDegree(nodeLabels, nodeIncoming, this.collectedData.getIncomingDegree());
        this.recordNodeDegree(nodeLabels, nodeOutgoing, this.collectedData.getOutcomingDegree());
        this.recordNodeDegree(nodeLabels, nodeIncoming, this.collectedData.getBothDegree());
        this.recordNodeDegree(nodeLabels, nodeOutgoing, this.collectedData.getBothDegree());
        this.collectedData.recordNodeLiveEntity();
    }

    private void recordNodeDegree(List<Integer> nodeLabels, Map<Integer, Integer> source, Map<Integer, Map<Integer, RollingAverage>> degreeMap) {
        for (Map.Entry<Integer, Integer> entry : source.entrySet()) {
            for (Integer nodeLabel : Iterables.append(-1, nodeLabels)) {
                RollingAverage histogram;
                Map<Integer, RollingAverage> reltypeMap = degreeMap.get(nodeLabel);
                if (reltypeMap == null) {
                    reltypeMap = new HashMap<Integer, RollingAverage>();
                    degreeMap.put(nodeLabel, reltypeMap);
                }
                if ((histogram = reltypeMap.get(entry.getKey())) == null) {
                    histogram = new RollingAverage(this.collectedData.getParameters());
                    reltypeMap.put(entry.getKey(), histogram);
                }
                histogram.record(entry.getValue().intValue());
            }
        }
    }

    public StatisticsData collectedData() {
        return this.collectedData;
    }

    @Override
    public void run() {
        for (int i = 0; i < 100; ++i) {
            long id = this.random.nextLong() % this.store.highestNodeIdInUse();
            if (this.store.nodeExists(id)) {
                try {
                    List<Integer> relTypes = IteratorUtil.asList(this.store.nodeGetRelationshipTypes(id));
                    List<Integer> labels = IteratorUtil.asList(this.store.nodeGetLabels(id));
                    HashMap<Integer, Integer> incomingDegrees = new HashMap<Integer, Integer>();
                    HashMap<Integer, Integer> outgoingDegrees = new HashMap<Integer, Integer>();
                    for (Integer relType : relTypes) {
                        incomingDegrees.put(relType, this.store.nodeGetDegree(id, Direction.INCOMING, relType));
                        outgoingDegrees.put(relType, this.store.nodeGetDegree(id, Direction.OUTGOING, relType));
                    }
                    this.addNodeObservation(labels, relTypes, incomingDegrees, outgoingDegrees);
                }
                catch (EntityNotFoundException e) {
                    this.collectedData.recordNodeDeadEntity();
                }
                continue;
            }
            this.collectedData.recordNodeDeadEntity();
        }
        this.collectedData.recordHighestNodeId(this.store.highestNodeIdInUse());
        this.collectedData.recalculate();
    }
}

