/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.traversal;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;

public class Paths {
    public static <T extends Path> String pathToString(T path, PathDescriptor<T> builder) {
        Node current = path.startNode();
        StringBuilder result = new StringBuilder();
        for (Relationship rel : path.relationships()) {
            result.append(builder.nodeRepresentation(path, current));
            result.append(builder.relationshipRepresentation(path, current, rel));
            current = rel.getOtherNode(current);
        }
        if (null != current) {
            result.append(builder.nodeRepresentation(path, current));
        }
        return result.toString();
    }

    public static String defaultPathToString(Path path) {
        return Paths.pathToString(path, new DefaultPathDescriptor());
    }

    public static String simplePathToString(Path path) {
        return Paths.pathToString(path, new DefaultPathDescriptor<Path>(){

            @Override
            public String relationshipRepresentation(Path path, Node from, Relationship relationship) {
                return relationship.getStartNode().equals(from) ? "-->" : "<--";
            }
        });
    }

    public static String simplePathToString(Path path, final String nodePropertyKey) {
        return Paths.pathToString(path, new DefaultPathDescriptor<Path>(){

            @Override
            public String nodeRepresentation(Path path, Node node) {
                return "(" + node.getProperty(nodePropertyKey, node.getId()) + ")";
            }

            @Override
            public String relationshipRepresentation(Path path, Node from, Relationship relationship) {
                return relationship.getStartNode().equals(from) ? "-->" : "<--";
            }
        });
    }

    public static class DefaultPathDescriptor<T extends Path>
    implements PathDescriptor<T> {
        @Override
        public String nodeRepresentation(Path path, Node node) {
            return "(" + node.getId() + ")";
        }

        @Override
        public String relationshipRepresentation(Path path, Node from, Relationship relationship) {
            String prefix = "--";
            String suffix = "--";
            if (from.equals(relationship.getEndNode())) {
                prefix = "<--";
            } else {
                suffix = "-->";
            }
            return prefix + "[" + relationship.getType().name() + "," + relationship.getId() + "]" + suffix;
        }
    }

    public static interface PathDescriptor<T extends Path> {
        public String nodeRepresentation(T var1, Node var2);

        public String relationshipRepresentation(T var1, Node var2, Relationship var3);
    }
}

