/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.kernel.StandardExpander;

public abstract class PathExpanders {
    public static <STATE> PathExpander<STATE> allTypesAndDirections() {
        return StandardExpander.DEFAULT;
    }

    public static <STATE> PathExpander<STATE> forType(RelationshipType type) {
        return StandardExpander.create(type, Direction.BOTH);
    }

    public static <STATE> PathExpander<STATE> forDirection(Direction direction) {
        return StandardExpander.create(direction);
    }

    public static <STATE> PathExpander<STATE> forTypeAndDirection(RelationshipType type, Direction direction) {
        return StandardExpander.create(type, direction);
    }

    public static <STATE> PathExpander<STATE> forTypesAndDirections(RelationshipType type1, Direction direction1, RelationshipType type2, Direction direction2, Object ... more) {
        return StandardExpander.create(type1, direction1, type2, direction2, more);
    }

    public static <STATE> PathExpander<STATE> forConstantDirectionWithTypes(final RelationshipType ... types) {
        return new PathExpander<STATE>(){

            @Override
            public Iterable<Relationship> expand(Path path, BranchState<STATE> state) {
                if (path.length() == 0) {
                    return path.endNode().getRelationships(types);
                }
                Direction direction = this.getDirectionOfLastRelationship(path);
                return path.endNode().getRelationships(direction, types);
            }

            @Override
            public PathExpander<STATE> reverse() {
                return this;
            }

            private Direction getDirectionOfLastRelationship(Path path) {
                assert (path.length() > 0);
                Direction direction = Direction.INCOMING;
                if (path.endNode().equals(path.lastRelationship().getEndNode())) {
                    direction = Direction.OUTGOING;
                }
                return direction;
            }
        };
    }

    private PathExpanders() {
    }
}

