/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ehcache.persistencestrategy.kind.impl;

import net.sf.ehcache.CacheManager;
import org.hibernate.ogm.datastore.ehcache.impl.Cache;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.impl.LocalCacheManager;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.kind.impl.SerializableAssociationKey;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.kind.impl.SerializableEntityKey;
import org.hibernate.ogm.datastore.ehcache.persistencestrategy.kind.impl.SerializableIdSourceKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;

public class OnePerKindCacheManager
extends LocalCacheManager<SerializableEntityKey, SerializableAssociationKey, SerializableIdSourceKey> {
    private final Cache<SerializableEntityKey> entityCache;
    private final Cache<SerializableAssociationKey> associationCache;
    private final Cache<SerializableIdSourceKey> idSourceCache;

    public OnePerKindCacheManager(CacheManager cacheManager) {
        super(cacheManager);
        this.entityCache = new Cache(cacheManager.getCache("ENTITIES"));
        this.associationCache = new Cache(cacheManager.getCache("ASSOCIATIONS"));
        this.idSourceCache = new Cache(cacheManager.getCache("IDENTIFIERS"));
    }

    @Override
    public Cache<SerializableEntityKey> getEntityCache(EntityKeyMetadata keyMetadata) {
        return this.entityCache;
    }

    @Override
    public Cache<SerializableAssociationKey> getAssociationCache(AssociationKeyMetadata keyMetadata) {
        return this.associationCache;
    }

    @Override
    public Cache<SerializableIdSourceKey> getIdSourceCache(IdSourceKeyMetadata keyMetadata) {
        return this.idSourceCache;
    }

    @Override
    public void forEachTuple(LocalCacheManager.KeyProcessor<SerializableEntityKey> processor, EntityKeyMetadata ... entityKeyMetadatas) {
        for (SerializableEntityKey key : this.entityCache.getKeys()) {
            for (EntityKeyMetadata entityKeyMetadata : entityKeyMetadatas) {
                if (!key.getTable().equals(entityKeyMetadata.getTable())) continue;
                processor.processKey(key, this.entityCache);
            }
        }
    }
}

