/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.transaction.impl;

import java.util.Map;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.engine.transaction.jta.platform.internal.JBossStandAloneJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.JtaPlatformInitiator;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.ogm.datastore.impl.AvailableDatastoreProvider;
import org.hibernate.ogm.datastore.impl.DatastoreProviderInitiator;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.service.impl.OptionalServiceInitiator;
import org.hibernate.ogm.util.configurationreader.spi.ConfigurationPropertyReader;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class OgmJtaPlatformInitiator
extends OptionalServiceInitiator<JtaPlatform> {
    public static final OgmJtaPlatformInitiator INSTANCE = new OgmJtaPlatformInitiator();

    public Class<JtaPlatform> getServiceInitiated() {
        return JtaPlatform.class;
    }

    @Override
    protected JtaPlatform buildServiceInstance(Map configurationValues, ServiceRegistryImplementor registry) {
        if (this.hasExplicitPlatform(configurationValues)) {
            return JtaPlatformInitiator.INSTANCE.initiateService(configurationValues, registry);
        }
        if (this.isNeo4j(configurationValues, (ClassLoaderService)registry.getService(ClassLoaderService.class))) {
            configurationValues.put("hibernate.transaction.jta.platform", "org.hibernate.ogm.datastore.neo4j.transaction.impl.Neo4jJtaPlatform");
            return JtaPlatformInitiator.INSTANCE.initiateService(configurationValues, registry);
        }
        return new JBossStandAloneJtaPlatform();
    }

    private boolean isNeo4j(Map configuration, ClassLoaderService classLoaderService) {
        DatastoreProvider configuredProvider = (DatastoreProvider)new ConfigurationPropertyReader(configuration, classLoaderService).property("hibernate.ogm.datastore.provider", DatastoreProvider.class).instantiate().withShortNameResolver(new DatastoreProviderInitiator.DatastoreProviderShortNameResolver()).getValue();
        return configuredProvider != null && configuredProvider.getClass().getName().equals(AvailableDatastoreProvider.NEO4J_EMBEDDED.getDatastoreProviderClassName());
    }

    @Override
    protected StandardServiceInitiator<JtaPlatform> backupInitiator() {
        return JtaPlatformInitiator.INSTANCE;
    }

    private boolean hasExplicitPlatform(Map configVales) {
        return configVales.containsKey("hibernate.transaction.jta.platform");
    }
}

